/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.PriorityMapping;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.ArrayList;
import java.util.List;

public class FileStorProducer
implements StorFilestorConfig.Producer {
    private List<StorFilestorConfig.Threads.Builder> threads;
    private ContentCluster cluster;

    public FileStorProducer(ContentCluster parent, List<StorFilestorConfig.Threads.Builder> threads) {
        this.threads = threads;
        this.cluster = parent;
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        if (this.threads != null) {
            for (StorFilestorConfig.Threads.Builder t : this.threads) {
                builder.threads.add(t);
            }
        }
        builder.enable_multibit_split_optimalization(this.cluster.getPersistence().enableMultiLevelSplitting());
    }

    public static class Builder {
        protected FileStorProducer build(ContentCluster parent, ModelElement clusterElem) {
            return new FileStorProducer(parent, this.getThreads(clusterElem));
        }

        private List<StorFilestorConfig.Threads.Builder> getThreads(ModelElement clusterElem) {
            ModelElement tuning = clusterElem.getChild("tuning");
            if (tuning == null) {
                return null;
            }
            ModelElement threads = tuning.getChild("persistence-threads");
            if (threads == null) {
                return null;
            }
            ArrayList<StorFilestorConfig.Threads.Builder> retVal = new ArrayList<StorFilestorConfig.Threads.Builder>();
            PriorityMapping mapping = new PriorityMapping(clusterElem);
            for (ModelElement thread : threads.subElements("thread")) {
                Integer count;
                String priorityName = thread.getStringAttribute("lowest-priority");
                if (priorityName == null) {
                    priorityName = "LOWEST";
                }
                if ((count = thread.getIntegerAttribute("count")) == null) {
                    count = 1;
                }
                for (int i = 0; i < count; ++i) {
                    retVal.add(new StorFilestorConfig.Threads.Builder().lowestpri(mapping.getPriorityMapping(priorityName)));
                }
            }
            return retVal;
        }
    }
}

