/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.ClusterInfoConfig;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.cloud.config.RoutingProviderConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.concurrent.classlock.ClassLocking;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.docproc.DocprocConfig;
import com.yahoo.config.docproc.SchemamappingConfig;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.Rotation;
import com.yahoo.config.provision.Zone;
import com.yahoo.container.BundlesConfig;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.core.document.ContainerDocumentConfig;
import com.yahoo.container.handler.ThreadPoolProvider;
import com.yahoo.container.handler.ThreadpoolConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import com.yahoo.container.jdisc.config.MetricDefaultsConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.container.usability.BindingsOverviewHandler;
import com.yahoo.container.xml.providers.DatatypeFactoryProvider;
import com.yahoo.container.xml.providers.DocumentBuilderFactoryProvider;
import com.yahoo.container.xml.providers.JAXBContextFactoryProvider;
import com.yahoo.container.xml.providers.SAXParserFactoryProvider;
import com.yahoo.container.xml.providers.SchemaFactoryProvider;
import com.yahoo.container.xml.providers.TransformerFactoryProvider;
import com.yahoo.container.xml.providers.XMLEventFactoryProvider;
import com.yahoo.container.xml.providers.XMLInputFactoryProvider;
import com.yahoo.container.xml.providers.XMLOutputFactoryProvider;
import com.yahoo.container.xml.providers.XPathFactoryProvider;
import com.yahoo.document.config.DocumentmanagerConfig;
import com.yahoo.jdisc.http.ServletPathsConfig;
import com.yahoo.metrics.simple.MetricManager;
import com.yahoo.metrics.simple.jdisc.JdiscMetricsFactory;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.prelude.semantics.SemanticRulesConfig;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.search.pagetemplates.PageTemplatesConfig;
import com.yahoo.search.query.profile.config.QueryProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.clients.ContainerDocumentApi;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerClusterVerifier;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.ConfigProducerGroup;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.Servlet;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.component.StatisticsComponent;
import com.yahoo.vespa.model.container.component.chain.ProcessingHandler;
import com.yahoo.vespa.model.container.docproc.ContainerDocproc;
import com.yahoo.vespa.model.container.docproc.DocprocChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.jersey.Jersey2Servlet;
import com.yahoo.vespa.model.container.jersey.JerseyHandler;
import com.yahoo.vespa.model.container.jersey.RestApi;
import com.yahoo.vespa.model.container.processing.ProcessingChains;
import com.yahoo.vespa.model.container.search.ContainerSearch;
import com.yahoo.vespa.model.container.search.searchchain.SearchChains;
import com.yahoo.vespa.model.content.Content;
import com.yahoo.vespa.model.search.AbstractSearchCluster;
import com.yahoo.vespa.model.utils.FileSender;
import com.yahoo.vespaclient.config.FeederConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ContainerCluster
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
DocumentmanagerConfig.Producer,
ContainerMbusConfig.Producer,
ContainerDocumentConfig.Producer,
HealthMonitorConfig.Producer,
ApplicationMetadataConfig.Producer,
BundlesConfig.Producer,
FeederConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemamappingConfig.Producer,
QrSearchersConfig.Producer,
QrStartConfig.Producer,
QueryProfilesConfig.Producer,
PageTemplatesConfig.Producer,
SemanticRulesConfig.Producer,
DocprocConfig.Producer,
MetricDefaultsConfig.Producer,
ClusterInfoConfig.Producer,
ServletPathsConfig.Producer,
RoutingProviderConfig.Producer,
ConfigserverConfig.Producer,
ThreadpoolConfig.Producer {
    public static final String RESERVED_URI_PREFIX = "reserved-for-internal-use";
    public static final String APPLICATION_STATUS_HANDLER_CLASS = "com.yahoo.container.handler.observability.ApplicationStatusHandler";
    public static final String BINDINGS_OVERVIEW_HANDLER_CLASS = BindingsOverviewHandler.class.getName();
    public static final String STATE_HANDLER_CLASS = "com.yahoo.container.jdisc.state.StateHandler";
    public static final String STATISTICS_HANDLER_CLASS = "com.yahoo.container.config.StatisticsRequestHandler";
    public static final String SIMPLE_LINGUISTICS_PROVIDER = "com.yahoo.language.provider.SimpleLinguisticsProvider";
    public static final String ROOT_HANDLER_BINDING = "*://*/";
    private final String name;
    private List<Container> containers = new ArrayList<Container>();
    private Http http;
    private ProcessingChains processingChains;
    private ContainerSearch containerSearch;
    private ContainerDocproc containerDocproc;
    private ContainerDocumentApi containerDocumentApi;
    private MbusParams mbusParams;
    private final Set<FileReference> applicationBundles = new LinkedHashSet<FileReference>();
    private final Set<Path> platformBundles = new LinkedHashSet<Path>();
    private final List<String> serviceAliases = new ArrayList<String>();
    private final List<String> endpointAliases = new ArrayList<String>();
    protected final ComponentGroup<Component<?, ?>> componentGroup;
    private final ConfigProducerGroup<RestApi> restApiGroup;
    private final ConfigProducerGroup<Servlet> servletGroup;
    private final ContainerClusterVerifier clusterVerifier;
    private Map<String, String> concreteDocumentTypes = new LinkedHashMap<String, String>();
    private MetricDefaultsConfig.Factory.Enum defaultMetricConsumerFactory;
    private ApplicationMetaData applicationMetaData = null;
    private Zone zone;
    private Optional<String> hostClusterId = Optional.empty();
    private Optional<Integer> memoryPercentage = Optional.empty();

    public ContainerCluster(AbstractConfigProducer<?> parent, String subId, String name) {
        this(parent, subId, name, new AcceptAllVerifier());
    }

    public ContainerCluster(AbstractConfigProducer<?> parent, String subId, String name, ContainerClusterVerifier verifier) {
        super(parent, subId);
        this.clusterVerifier = verifier;
        this.name = name;
        this.zone = this.getRoot() != null ? this.getRoot().getDeployState().zone() : Zone.defaultZone();
        this.componentGroup = new ComponentGroup(this, "component");
        this.restApiGroup = new ConfigProducerGroup(this, "rest-api");
        this.servletGroup = new ConfigProducerGroup(this, "servlet");
        this.addComponent(new StatisticsComponent());
        this.addSimpleComponent(AccessLog.class);
        this.addSimpleComponent(ThreadPoolProvider.class);
        this.addSimpleComponent(ClassLocking.class);
        this.addSimpleComponent("com.yahoo.jdisc.http.filter.SecurityFilterInvoker");
        this.addSimpleComponent(SIMPLE_LINGUISTICS_PROVIDER);
        this.addSimpleComponent("com.yahoo.container.jdisc.SecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.CertificateStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricConsumerProviderProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.metric.MetricUpdater");
        this.addSimpleComponent(MetricManager.class.getName(), null, "simplemetrics");
        this.addSimpleComponent(JdiscMetricsFactory.class.getName(), null, "simplemetrics");
        this.addSimpleComponent("com.yahoo.container.jdisc.state.StateMonitor");
        this.addSimpleComponent("com.yahoo.container.jdisc.ContainerThreadFactory");
        this.addSimpleComponent("com.yahoo.container.protect.FreezeDetector");
        this.addSimpleComponent("com.yahoo.container.core.slobrok.SlobrokConfigurator");
        this.addSimpleComponent("com.yahoo.container.handler.VipStatus");
        this.addJaxProviders();
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void addMetricStateHandler() {
        Handler stateHandler = new Handler(new ComponentModel(STATE_HANDLER_CLASS, null, null, null));
        stateHandler.addServerBindings("http://*/state/v1", "https://*/state/v1", "http://*/state/v1/*", "https://*/state/v1/*");
        this.addComponent(stateHandler);
    }

    public void addDefaultRootHandler() {
        if (this.hasHandlerWithBinding(ROOT_HANDLER_BINDING)) {
            return;
        }
        Handler handler = new Handler(new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)BINDINGS_OVERVIEW_HANDLER_CLASS, null, null), null));
        handler.addServerBindings(ROOT_HANDLER_BINDING);
        this.addComponent(handler);
    }

    private boolean hasHandlerWithBinding(String binding) {
        Collection<Handler<?>> handlers = this.getHandlers();
        for (Handler<?> handler : handlers) {
            if (!handler.getServerBindings().contains(binding)) continue;
            return true;
        }
        return false;
    }

    public void addApplicationStatusHandler() {
        Handler statusHandler = new Handler(new ComponentModel(BundleInstantiationSpecification.getInternalHandlerSpecificationFromStrings((String)APPLICATION_STATUS_HANDLER_CLASS, null), null));
        statusHandler.addServerBindings("http://*/ApplicationStatus", "https://*/ApplicationStatus");
        this.addComponent(statusHandler);
    }

    public void addVipHandler() {
        Handler<AbstractConfigProducer<?>> vipHandler = Handler.fromClassName("com.yahoo.container.handler.VipStatusHandler");
        vipHandler.addServerBindings("http://*/status.html", "https://*/status.html");
        this.addComponent(vipHandler);
    }

    public void addStatisticsHandler() {
        Handler<AbstractConfigProducer<?>> statsHandler = Handler.fromClassName(STATISTICS_HANDLER_CLASS);
        statsHandler.addServerBindings("http://*/statistics/*", "https://*/statistics/*");
        this.addComponent(statsHandler);
    }

    public void addJaxProviders() {
        this.addSimpleComponent(DatatypeFactoryProvider.class);
        this.addSimpleComponent(DocumentBuilderFactoryProvider.class);
        this.addSimpleComponent(JAXBContextFactoryProvider.class);
        this.addSimpleComponent(SAXParserFactoryProvider.class);
        this.addSimpleComponent(SchemaFactoryProvider.class);
        this.addSimpleComponent(TransformerFactoryProvider.class);
        this.addSimpleComponent(XMLEventFactoryProvider.class);
        this.addSimpleComponent(XMLInputFactoryProvider.class);
        this.addSimpleComponent(XMLOutputFactoryProvider.class);
        this.addSimpleComponent(XPathFactoryProvider.class);
    }

    public final void addComponent(Component<?, ?> component) {
        if (this.clusterVerifier.acceptComponent(component)) {
            this.componentGroup.addComponent(component);
        }
    }

    public final void addSimpleComponent(String idSpec, String classSpec, String bundleSpec) {
        this.addComponent(new SimpleComponent(new ComponentModel(idSpec, classSpec, bundleSpec)));
    }

    public Component removeComponent(ComponentId componentId) {
        return (Component)this.componentGroup.removeComponent(componentId);
    }

    public void addSimpleComponent(Class<?> clazz) {
        this.addSimpleComponent(clazz.getName());
    }

    private void addSimpleComponent(String className) {
        this.addComponent(new SimpleComponent(className));
    }

    public void prepare() {
        this.addAndSendApplicationBundles();
        this.sendUserConfiguredFiles();
        this.setApplicationMetaData();
        for (RestApi restApi : this.restApiGroup.getComponents()) {
            restApi.prepare();
        }
    }

    private void setApplicationMetaData() {
        this.applicationMetaData = this.getRoot().getDeployState().getApplicationPackage().getMetaData();
    }

    public void addMbusServer(ComponentId chainId) {
        ComponentId serviceId = chainId.nestInNamespace(ComponentId.fromString((String)"MbusServer"));
        this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(serviceId, ComponentSpecification.fromString((String)MbusServerProvider.class.getName()), null))));
    }

    private void addAndSendApplicationBundles() {
        for (ComponentInfo component : this.getRoot().getDeployState().getApplicationPackage().getComponentsInfo(this.getRoot().getDeployState().getProperties().vespaVersion())) {
            FileReference reference = FileSender.sendFileToServices(component.getPathRelativeToAppDir(), this.containers);
            this.applicationBundles.add(reference);
        }
    }

    private void sendUserConfiguredFiles() {
        for (Component<?, ?> component : this.getAllComponents()) {
            FileSender.sendUserConfiguredFiles(component, this.containers, this.deployLogger());
        }
    }

    public String getName() {
        return this.name;
    }

    public List<Container> getContainers() {
        return Collections.unmodifiableList(this.containers);
    }

    public void addContainer(Container container) {
        if (!this.clusterVerifier.acceptContainer(container)) {
            throw new IllegalArgumentException("Cluster " + this.name + " does not accept container " + container);
        }
        container.setClusterName(this.name);
        container.setProp("clustername", this.name).setProp("index", this.containers.size());
        this.setRotations(container, this.getRotations(), this.getGlobalServiceId(), this.name);
        container.setProp("activeRotation", Boolean.toString(this.getActiveRotation()));
        this.containers.add(container);
    }

    public void addContainers(Collection<Container> containers) {
        for (Container container : containers) {
            this.addContainer(container);
        }
    }

    private Optional<String> getGlobalServiceId() {
        Optional<DeploymentSpec> deploymentSpec = this.getDeploymentSpec();
        if (deploymentSpec.isPresent()) {
            return deploymentSpec.get().globalServiceId();
        }
        return Optional.empty();
    }

    private Set<Rotation> getRotations() {
        return Optional.ofNullable(this.getRoot()).map(root -> root.getDeployState().getRotations()).orElse(Collections.emptySet());
    }

    private boolean getActiveRotation() {
        return Optional.ofNullable(this.getRoot()).map(root -> root.getDeployState().getProperties().zone()).map(this::zoneHasActiveRotation).orElse(false);
    }

    private boolean zoneHasActiveRotation(Zone zone) {
        Optional<DeploymentSpec> spec = this.getDeploymentSpec();
        if (!spec.isPresent()) {
            return false;
        }
        return spec.get().zones().stream().anyMatch(declaredZone -> declaredZone.deploysTo(zone.environment(), Optional.of(zone.region())) && declaredZone.active());
    }

    private Optional<DeploymentSpec> getDeploymentSpec() {
        Optional deployment;
        Optional<DeploymentSpec> deploymentSpec = Optional.empty();
        AbstractConfigProducerRoot root = this.getRoot();
        if (root != null && (deployment = root.getDeployState().getApplicationPackage().getDeployment()).isPresent()) {
            deploymentSpec = Optional.of(DeploymentSpec.fromXml((Reader)((Reader)deployment.get())));
        }
        return deploymentSpec;
    }

    private void setRotations(Container container, Set<Rotation> rotations, Optional<String> globalServiceId, String containerClusterName) {
        if (!rotations.isEmpty() && globalServiceId.isPresent() && containerClusterName.equals(globalServiceId.get())) {
            container.setProp("rotations", rotations.stream().map(Rotation::getId).collect(Collectors.joining(",")));
        }
    }

    public void setProcessingChains(ProcessingChains processingChains, String ... serverBindings) {
        if (this.processingChains != null) {
            throw new IllegalStateException("ProcessingChains should only be set once.");
        }
        this.processingChains = processingChains;
        ProcessingHandler<ProcessingChains> processingHandler = new ProcessingHandler<ProcessingChains>(processingChains, "com.yahoo.processing.handler.ProcessingHandler");
        for (String binding : serverBindings) {
            processingHandler.addServerBindings(binding);
        }
        this.addComponent(processingHandler);
    }

    public ProcessingChains getProcessingChains() {
        return this.processingChains;
    }

    @NonNull
    public SearchChains getSearchChains() {
        if (this.containerSearch == null) {
            throw new IllegalStateException("Null search components!");
        }
        return (SearchChains)this.containerSearch.getChains();
    }

    @Nullable
    public ContainerSearch getSearch() {
        return this.containerSearch;
    }

    public void setSearch(ContainerSearch containerSearch) {
        this.containerSearch = containerSearch;
    }

    public void setHttp(Http http) {
        this.http = http;
        this.addChild(http);
    }

    @Nullable
    public Http getHttp() {
        return this.http;
    }

    public final void addRestApi(@NonNull RestApi restApi) {
        this.restApiGroup.addComponent(ComponentId.fromString((String)restApi.getBindingPath()), restApi);
    }

    public Map<ComponentId, RestApi> getRestApiMap() {
        return this.restApiGroup.getComponentMap();
    }

    public Map<ComponentId, Servlet> getServletMap() {
        return this.servletGroup.getComponentMap();
    }

    public final void addServlet(@NonNull Servlet servlet) {
        this.servletGroup.addComponent(servlet.getGlobalComponentId(), servlet);
    }

    @Nullable
    public ContainerDocproc getDocproc() {
        return this.containerDocproc;
    }

    public void setDocproc(ContainerDocproc containerDocproc) {
        this.containerDocproc = containerDocproc;
    }

    @Nullable
    public ContainerDocumentApi getDocumentApi() {
        return this.containerDocumentApi;
    }

    public void setDocumentApi(ContainerDocumentApi containerDocumentApi) {
        this.containerDocumentApi = containerDocumentApi;
    }

    @NonNull
    public DocprocChains getDocprocChains() {
        if (this.containerDocproc == null) {
            throw new IllegalStateException("Null docproc components!");
        }
        return (DocprocChains)this.containerDocproc.getChains();
    }

    public Collection<Handler<?>> getHandlers() {
        return this.componentGroup.getComponents(Handler.class);
    }

    public Collection<Servlet> getAllServlets() {
        return this.allServlets().collect(Collectors.toCollection(ArrayList::new));
    }

    public Map<ComponentId, Component<?, ?>> getComponentsMap() {
        return this.componentGroup.getComponentMap();
    }

    public Collection<Component<?, ?>> getAllComponents() {
        ArrayList allComponents = new ArrayList();
        this.recursivelyFindAllComponents(allComponents, this);
        Collections.sort(allComponents);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void recursivelyFindAllComponents(Collection<Component<?, ?>> allComponents, AbstractConfigProducer<?> current) {
        for (AbstractConfigProducer child : current.getChildren().values()) {
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            if (child instanceof Container) continue;
            this.recursivelyFindAllComponents(allComponents, child);
        }
    }

    public final void getConfig(ComponentsConfig.Builder builder) {
        builder.components.addAll(ComponentsConfigGenerator.generate(this.getAllComponents()));
        builder.components(new ComponentsConfig.Components.Builder().id("com.yahoo.container.core.config.HandlersConfigurerDi$RegistriesHack"));
    }

    public final void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers.putAll(DiscBindingsConfigGenerator.generate(this.getHandlers()));
        this.allJersey1Handlers().forEach(handler -> builder.handlers.putAll(DiscBindingsConfigGenerator.generate(handler)));
    }

    public void getConfig(ThreadpoolConfig.Builder builder) {
        this.clusterVerifier.getConfig(builder);
    }

    private Stream<JerseyHandler> allJersey1Handlers() {
        return this.restApiGroup.getComponents().stream().flatMap(this.streamOf(RestApi::getJersey1Handler));
    }

    public void getConfig(ServletPathsConfig.Builder builder) {
        this.allServlets().forEach(servlet -> builder.servlets(servlet.getComponentId().stringValue(), servlet.toConfigBuilder()));
    }

    private Stream<Servlet> allServlets() {
        return Stream.concat(this.allJersey2Servlets(), this.servletGroup.getComponents().stream());
    }

    private Stream<Jersey2Servlet> allJersey2Servlets() {
        return this.restApiGroup.getComponents().stream().flatMap(this.streamOf(RestApi::getJersey2Servlet));
    }

    private <T, R> Function<T, Stream<R>> streamOf(Function<T, Optional<R>> f) {
        return t -> ((Optional)f.apply(t)).map(Stream::of).orElse(Stream.empty());
    }

    public void getConfig(DocumentmanagerConfig.Builder builder) {
        if (this.containerDocproc != null && this.containerDocproc.isCompressDocuments()) {
            builder.enablecompression(true);
        }
    }

    public void getConfig(ContainerDocumentConfig.Builder builder) {
        for (Map.Entry<String, String> e : this.concreteDocumentTypes.entrySet()) {
            ContainerDocumentConfig.Doctype.Builder dtb = new ContainerDocumentConfig.Doctype.Builder();
            dtb.type(e.getKey());
            dtb.factorycomponent(e.getValue());
            builder.doctype(dtb);
        }
    }

    public void getConfig(HealthMonitorConfig.Builder builder) {
        Monitoring monitoring = this.getMonitoringService();
        if (monitoring != null) {
            builder.snapshot_interval((double)monitoring.getIntervalSeconds().intValue());
        }
    }

    public void getConfig(ApplicationMetadataConfig.Builder builder) {
        if (this.applicationMetaData != null) {
            builder.name(this.applicationMetaData.getApplicationName()).user(this.applicationMetaData.getDeployedByUser()).path(this.applicationMetaData.getDeployPath()).timestamp(this.applicationMetaData.getDeployTimestamp().longValue()).checksum(this.applicationMetaData.getCheckSum()).generation(this.applicationMetaData.getGeneration().longValue());
        }
    }

    public final void addPlatformBundle(Path bundlePath) {
        this.platformBundles.add(bundlePath);
    }

    public void getConfig(BundlesConfig.Builder builder) {
        Stream.concat(this.applicationBundles.stream().map(FileReference::value), this.platformBundles.stream().map(ContainerCluster::toFileReferenceString)).forEach(arg_0 -> ((BundlesConfig.Builder)builder).bundle(arg_0));
    }

    private static String toFileReferenceString(Path path) {
        return "file:" + path.toString();
    }

    public void getConfig(QrSearchersConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QrStartConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(DocprocConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(PageTemplatesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SemanticRulesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(QueryProfilesConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(SchemamappingConfig.Builder builder) {
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        if (this.containerSearch != null) {
            this.containerSearch.getConfig(builder);
        }
    }

    public void getConfig(FeederConfig.Builder builder) {
        if (this.containerDocumentApi != null) {
            this.containerDocumentApi.getConfig(builder);
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        if (this.mbusParams != null) {
            if (this.mbusParams.maxConcurrentFactor != null) {
                builder.maxConcurrentFactor(this.mbusParams.maxConcurrentFactor.doubleValue());
            }
            if (this.mbusParams.documentExpansionFactor != null) {
                builder.documentExpansionFactor(this.mbusParams.documentExpansionFactor.doubleValue());
            }
            if (this.mbusParams.containerCoreMemory != null) {
                builder.containerCoreMemory(this.mbusParams.containerCoreMemory.intValue());
            }
        }
        if (this.containerDocproc != null) {
            this.containerDocproc.getConfig(builder);
        }
    }

    public void setMbusParams(MbusParams mbusParams) {
        this.mbusParams = mbusParams;
    }

    public void initialize(Map<String, AbstractSearchCluster> clusterMap) {
        if (this.containerSearch != null) {
            this.containerSearch.connectSearchClusters(clusterMap);
        }
    }

    public void addDefaultSearchAccessLog() {
        this.addComponent(new AccessLogComponent(AccessLogComponent.AccessLogType.queryAccessLog, this.getName()));
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        ArrayList<AbstractSearchCluster> searchClusters = new ArrayList<AbstractSearchCluster>();
        searchClusters.addAll(Content.getSearchClusters(this.getRoot().configModelRepo()));
        for (AbstractSearchCluster searchCluster : searchClusters) {
            searchCluster.getConfig(builder);
        }
    }

    public void getConfig(MetricDefaultsConfig.Builder builder) {
        if (this.defaultMetricConsumerFactory != null) {
            builder.factory(this.defaultMetricConsumerFactory);
        }
    }

    public void getConfig(ClusterInfoConfig.Builder builder) {
        builder.clusterId(this.name);
        builder.nodeCount(this.containers.size());
        for (Service service : this.getDescendantServices()) {
            builder.services.add(new ClusterInfoConfig.Services.Builder().index(Integer.parseInt(service.getServicePropertyString("index", "99999"))).hostname(service.getHostName()).ports(this.getPorts(service)));
        }
    }

    public void getConfig(ConfigserverConfig.Builder builder) {
        builder.system(this.zone.system().name());
        builder.environment(this.zone.environment().value());
        builder.region(this.zone.region().value());
    }

    private List<ClusterInfoConfig.Services.Ports.Builder> getPorts(Service service) {
        ArrayList<ClusterInfoConfig.Services.Ports.Builder> builders = new ArrayList<ClusterInfoConfig.Services.Ports.Builder>();
        PortsMeta portsMeta = service.getPortsMeta();
        for (int i = 0; i < portsMeta.getNumPorts(); ++i) {
            builders.add(new ClusterInfoConfig.Services.Ports.Builder().number(service.getRelativePort(i)).tags(ApplicationConfigProducerRoot.getPortTags(portsMeta, i)));
        }
        return builders;
    }

    public void setDefaultMetricConsumerFactory(MetricDefaultsConfig.Factory.Enum defaultMetricConsumerFactory) {
        Objects.requireNonNull(defaultMetricConsumerFactory, "defaultMetricConsumerFactory");
        this.defaultMetricConsumerFactory = defaultMetricConsumerFactory;
    }

    public void getConfig(RoutingProviderConfig.Builder builder) {
        builder.enabled(this.isHostedVespa());
    }

    public Map<String, String> concreteDocumentTypes() {
        return this.concreteDocumentTypes;
    }

    public List<String> serviceAliases() {
        return this.serviceAliases;
    }

    public List<String> endpointAliases() {
        return this.endpointAliases;
    }

    public void setHostClusterId(String clusterId) {
        this.hostClusterId = Optional.ofNullable(clusterId);
    }

    public Optional<String> getHostClusterId() {
        return this.hostClusterId;
    }

    public void setMemoryPercentage(Optional<Integer> memoryPercentage) {
        this.memoryPercentage = memoryPercentage;
    }

    public Optional<Integer> getMemoryPercentage() {
        return this.memoryPercentage;
    }

    public String toString() {
        return "container cluster '" + this.getName() + "'";
    }

    public static class MbusParams {
        final Double maxConcurrentFactor;
        final Double documentExpansionFactor;
        final Integer containerCoreMemory;

        public MbusParams(Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory) {
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }
    }

    private static class AcceptAllVerifier
    implements ContainerClusterVerifier {
        private AcceptAllVerifier() {
        }

        @Override
        public boolean acceptComponent(Component component) {
            return true;
        }

        @Override
        public boolean acceptContainer(Container container) {
            return true;
        }

        @Override
        public void getConfig(ThreadpoolConfig.Builder builder) {
        }
    }
}

