/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom.chains;

import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ChainsBuilder;
import com.yahoo.vespa.model.builder.xml.dom.chains.ComponentsBuilder;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.component.chain.Chains;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class DomChainsBuilder<COMPONENT extends ChainedComponent<?>, CHAIN extends Chain<COMPONENT>, CHAINS extends Chains<CHAIN>>
extends VespaDomBuilder.DomConfigProducerBuilder<CHAINS> {
    private final Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes;
    private final String appPkgChainsDir;
    private final Element outerChainsElem;

    protected DomChainsBuilder(Element outerChainsElem, Collection<ComponentsBuilder.ComponentType<COMPONENT>> allowedComponentTypes, String appPkgChainsDir) {
        this.outerChainsElem = outerChainsElem;
        this.allowedComponentTypes = new ArrayList<ComponentsBuilder.ComponentType<COMPONENT>>(allowedComponentTypes);
        this.appPkgChainsDir = appPkgChainsDir;
    }

    protected abstract CHAINS newChainsInstance(AbstractConfigProducer var1);

    @Override
    protected final CHAINS doBuild(AbstractConfigProducer parent, Element chainsElement) {
        CHAINS chains = this.newChainsInstance(parent);
        List<Element> allChainElements = this.allChainElements(parent, chainsElement);
        if (!allChainElements.isEmpty()) {
            ComponentsBuilder<COMPONENT> outerComponentsBuilder = this.readOuterComponents((AbstractConfigProducer)chains, allChainElements);
            ChainsBuilder<COMPONENT, CHAIN> chainsBuilder = this.readChains((AbstractConfigProducer)chains, allChainElements, outerComponentsBuilder.getComponentTypeByComponentName());
            this.addOuterComponents(chains, outerComponentsBuilder);
            this.addChains(chains, chainsBuilder);
        }
        return chains;
    }

    private List<Element> allChainElements(AbstractConfigProducer ancestor, Element chainsElement) {
        ArrayList<Element> chainsElements = new ArrayList<Element>();
        if (this.outerChainsElem != null) {
            chainsElements.add(this.outerChainsElem);
        }
        chainsElements.add(chainsElement);
        if (this.appPkgChainsDir != null) {
            chainsElements.addAll(Xml.allElemsFromPath((ApplicationPackage)ancestor.getRoot().getDeployState().getApplicationPackage(), (String)this.appPkgChainsDir));
        }
        return chainsElements;
    }

    private ComponentsBuilder<COMPONENT> readOuterComponents(AbstractConfigProducer ancestor, List<Element> chainsElems) {
        return new ComponentsBuilder(ancestor, this.allowedComponentTypes, chainsElems, null);
    }

    protected abstract ChainsBuilder<COMPONENT, CHAIN> readChains(AbstractConfigProducer var1, List<Element> var2, Map<String, ComponentsBuilder.ComponentType> var3);

    private void addOuterComponents(CHAINS chains, ComponentsBuilder<COMPONENT> outerComponentsBuilder) {
        assert (outerComponentsBuilder.getOuterComponentReferences().isEmpty());
        for (ChainedComponent outerComponent : outerComponentsBuilder.getComponentDefinitions()) {
            ((Chains)chains).add(outerComponent);
        }
    }

    private void addChains(CHAINS chains, ChainsBuilder<COMPONENT, CHAIN> chainsBuilder) {
        for (Chain chain : chainsBuilder.getChains()) {
            ((Chains)chains).add((Chain)chain);
        }
    }
}

