/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.DomComponentBuilder;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.xml.BundleInstantiationSpecificationBuilder;
import org.w3c.dom.Element;

public class DomHandlerBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Handler> {
    private final boolean legacyMode;

    public DomHandlerBuilder(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public DomHandlerBuilder() {
        this(false);
    }

    @Override
    protected Handler doBuild(AbstractConfigProducer ancestor, Element handlerElement) {
        Handler<Component<?, ?>> handler = this.getHandler(handlerElement);
        for (Element binding : XML.getChildren((Element)handlerElement, (String)"binding")) {
            handler.addServerBindings(XML.getValue((Element)binding));
        }
        for (Element clientBinding : XML.getChildren((Element)handlerElement, (String)"clientBinding")) {
            handler.addClientBindings(XML.getValue((Element)clientBinding));
        }
        DomComponentBuilder.addChildren(ancestor, handlerElement, handler);
        return handler;
    }

    protected Handler<? super Component<?, ?>> getHandler(Element handlerElement) {
        BundleInstantiationSpecification bundleSpec = BundleInstantiationSpecificationBuilder.build(handlerElement, this.legacyMode);
        return new Handler(new ComponentModel(bundleSpec));
    }
}

