/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.expressions.AttributeExpression;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.ForEachExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SummaryExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ZCurveExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class CreatePositionZCurve
extends Processor {
    public CreatePositionZCurve(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            SDField posY;
            DataType fieldType = field.getDataType();
            if (!CreatePositionZCurve.isSupportedPositionType(fieldType)) continue;
            if (field.doesIndexing()) {
                this.fail(this.search, field, "Indexing of data type '" + fieldType.getName() + "' is not supported, replace 'index' statement with 'attribute'.");
            }
            if (!field.doesAttributing()) continue;
            boolean doesSummary = field.doesSummarying();
            String fieldName = field.getName();
            field.getAttributes().remove(fieldName);
            String zName = PositionDataType.getZCurveFieldName((String)fieldName);
            SDField zCurveField = this.createZCurveField(field, zName);
            this.search.addExtraField(zCurveField);
            this.search.fieldSets().addBuiltInFieldSetItem("[internal]", zCurveField.getName());
            Set<String> summaryTo = this.removeSummaryTo(field);
            this.ensureCompatibleSummary(field, zName, PositionDataType.getPositionSummaryFieldName((String)fieldName), (DataType)DataType.getArray((DataType)DataType.STRING), SummaryTransform.POSITIONS, summaryTo);
            this.ensureCompatibleSummary(field, zName, PositionDataType.getDistanceSummaryFieldName((String)fieldName), (DataType)DataType.INT, SummaryTransform.DISTANCE, summaryTo);
            field.setIndexingScript(null);
            SDField posX = field.getStructField("x");
            if (posX != null) {
                posX.setIndexingScript(null);
            }
            if ((posY = field.getStructField("y")) != null) {
                posY.setIndexingScript(null);
            }
            if (!doesSummary) continue;
            this.ensureCompatibleSummary(field, zName, field.getName(), field.getDataType(), SummaryTransform.GEOPOS, summaryTo);
        }
    }

    private SDField createZCurveField(SDField inputField, String fieldName) {
        if (this.search.getConcreteField(fieldName) != null || this.search.getAttribute(fieldName) != null) {
            throw this.newProcessException(this.search, null, "Incompatible position attribute '" + fieldName + "' already created.");
        }
        boolean isArray = inputField.getDataType() instanceof ArrayDataType;
        SDField field = new SDField(fieldName, (DataType)(isArray ? DataType.getArray((DataType)DataType.LONG) : DataType.LONG));
        Attribute attribute = new Attribute(fieldName, Attribute.Type.LONG, isArray ? Attribute.CollectionType.ARRAY : Attribute.CollectionType.SINGLE);
        attribute.setPosition(true);
        attribute.setFastSearch(true);
        field.addAttribute(attribute);
        ScriptExpression script = inputField.getIndexingScript();
        script = (ScriptExpression)new RemoveSummary(inputField.getName()).convert((Expression)script);
        script = (ScriptExpression)new PerformZCurve(field, fieldName).convert((Expression)script);
        field.setIndexingScript(script);
        return field;
    }

    private void ensureCompatibleSummary(SDField field, String sourceName, String summaryName, DataType summaryType, SummaryTransform summaryTransform, Collection<String> summaryTo) {
        SummaryField summary = this.search.getSummaryField(summaryName);
        if (summary == null) {
            summary = new SummaryField(summaryName, summaryType, summaryTransform);
            summary.addDestination("default");
            summary.addDestinations(summaryTo);
            field.addSummaryField(summary);
        } else if (!summary.getDataType().equals((Object)summaryType)) {
            this.fail(this.search, field, "Incompatible summary field '" + summaryName + "' type " + summary.getDataType() + " already created.");
        } else if (summary.getTransform() == SummaryTransform.NONE) {
            summary.setTransform(summaryTransform);
            summary.addDestination("default");
            summary.addDestinations(summaryTo);
        } else if (summary.getTransform() != summaryTransform) {
            this.deployLogger.log(Level.WARNING, "Summary field " + summaryName + " has wrong transform: " + (Object)((Object)summary.getTransform()));
            return;
        }
        SummaryField.Source source = new SummaryField.Source(sourceName);
        summary.getSources().clear();
        summary.addSource(source);
    }

    private Set<String> removeSummaryTo(SDField field) {
        HashSet<String> summaryTo = new HashSet<String>();
        Collection<SummaryField> summaryFields = field.getSummaryFields();
        for (SummaryField summary : summaryFields) {
            summaryTo.addAll(summary.getDestinations());
        }
        summaryFields.clear();
        return summaryTo;
    }

    private static boolean isSupportedPositionType(DataType dataType) {
        if (dataType instanceof ArrayDataType) {
            dataType = ((ArrayDataType)dataType).getNestedType();
        }
        return dataType.equals((Object)PositionDataType.INSTANCE);
    }

    private static class PerformZCurve
    extends ExpressionConverter {
        final String find;
        final String replace;
        final boolean isArray;

        PerformZCurve(SDField find, String replace) {
            this.find = find.getName();
            this.replace = replace;
            this.isArray = find.getDataType() instanceof ArrayDataType;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof AttributeExpression)) {
                return false;
            }
            String fieldName = ((AttributeExpression)exp).getFieldName();
            return fieldName == null || fieldName.equals(this.find);
        }

        protected Expression doConvert(Expression exp) {
            return new StatementExpression(new Expression[]{this.isArray ? new ForEachExpression((Expression)new ZCurveExpression()) : new ZCurveExpression(), new AttributeExpression(this.replace)});
        }
    }

    private static class RemoveSummary
    extends ExpressionConverter {
        final String find;

        RemoveSummary(String find) {
            this.find = find;
        }

        protected boolean shouldConvert(Expression exp) {
            if (!(exp instanceof SummaryExpression)) {
                return false;
            }
            String fieldName = ((SummaryExpression)exp).getFieldName();
            return fieldName == null || fieldName.equals(this.find);
        }

        protected Expression doConvert(Expression exp) {
            return null;
        }
    }
}

