/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.SummaryClassField;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;

public class SummaryClass
extends Derived {
    private boolean accessingDiskSummary = false;
    private Map<String, SummaryClassField> fields = new LinkedHashMap<String, SummaryClassField>();
    private DeployLogger deployLogger = new BaseDeployLogger();
    private final Random random = new Random(7L);

    public SummaryClass(Search search, DocumentSummary summary, DeployLogger deployLogger) {
        this.deployLogger = deployLogger;
        this.deriveName(summary);
        this.deriveFields(search, summary);
        this.deriveImplicitFields(summary);
    }

    private void deriveName(DocumentSummary summary) {
        this.setName(summary.getName());
    }

    private void deriveImplicitFields(DocumentSummary summary) {
        if (summary.getName().equals("default")) {
            this.addField("documentid", (DataType)DataType.STRING);
        }
    }

    private void deriveFields(Search search, DocumentSummary summary) {
        for (SummaryField summaryField : summary.getSummaryFields()) {
            if (!this.accessingDiskSummary && search.isAccessingDiskSummary(summaryField)) {
                this.accessingDiskSummary = true;
            }
            this.addField(summaryField.getName(), summaryField.getDataType(), summaryField.getTransform());
        }
    }

    private void addField(String name, DataType type) {
        this.addField(name, type, null);
    }

    private void addField(String name, DataType type, SummaryTransform transform) {
        if (this.fields.containsKey(name)) {
            SummaryClassField sf = this.fields.get(name);
            if (!SummaryClassField.convertDataType(type, transform).equals((Object)sf.getType())) {
                this.deployLogger.log(Level.WARNING, "Conflicting definition of field " + name + ". Declared as type " + (Object)((Object)sf.getType()) + " and " + type);
            }
        } else {
            this.fields.put(name, new SummaryClassField(name, type, transform));
        }
    }

    public Iterator<SummaryClassField> fieldIterator() {
        return this.fields.values().iterator();
    }

    public void addField(SummaryClassField field) {
        this.fields.put(field.getName(), field);
    }

    public Map<String, SummaryClassField> getFields() {
        return this.fields;
    }

    public SummaryClassField getField(String name) {
        return this.fields.get(name);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public int hashCode() {
        int number = 1;
        int hash = this.getName().hashCode();
        Iterator<SummaryClassField> i = this.fieldIterator();
        while (i.hasNext()) {
            SummaryClassField field = i.next();
            hash += number * (field.getName().hashCode() + 17 * field.getType().getName().hashCode());
            ++number;
        }
        if (hash < 0) {
            hash *= -1;
        }
        return hash;
    }

    public SummaryConfig.Classes.Builder getSummaryClassConfig() {
        SummaryConfig.Classes.Builder classBuilder = new SummaryConfig.Classes.Builder();
        int id = this.hashCode();
        if (id == 0x55555555) {
            this.deployLogger.log(Level.WARNING, "Summary class '" + this.getName() + "' hashes to the SLIME_MAGIC_ID '" + id + "'. This is unlikely but I autofix it for you by adding a random number.");
            id += this.random.nextInt();
        }
        classBuilder.id(id).name(this.getName());
        for (SummaryClassField field : this.fields.values()) {
            classBuilder.fields(new SummaryConfig.Classes.Fields.Builder().name(field.getName()).type(field.getType().getName()));
        }
        return classBuilder;
    }

    @Override
    protected String getDerivedName() {
        return "summary";
    }

    public String toString() {
        return "summary class " + this.getName();
    }
}

