/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.derived.NativeTable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class FieldRankSettings {
    private static final Logger logger = Logger.getLogger(FieldRankSettings.class.getName());
    private String fieldName;
    private final Map<String, NativeTable> tables = new LinkedHashMap<String, NativeTable>();

    public FieldRankSettings(String fieldName) {
        this.fieldName = fieldName;
    }

    public void addTable(NativeTable table) {
        NativeTable existing = this.tables.get(table.getType().getName());
        if (existing != null) {
            logger.info("Using already specified rank table " + existing + " for field " + this.fieldName + ", not " + table);
            return;
        }
        this.tables.put(table.getType().getName(), table);
    }

    public static boolean isIndexFieldTable(NativeTable table) {
        return FieldRankSettings.isFieldMatchTable(table) || FieldRankSettings.isProximityTable(table);
    }

    public static boolean isAttributeFieldTable(NativeTable table) {
        return FieldRankSettings.isAttributeMatchTable(table);
    }

    private static boolean isFieldMatchTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.FIRST_OCCURRENCE) || table.getType().equals(NativeTable.Type.OCCURRENCE_COUNT);
    }

    private static boolean isAttributeMatchTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.WEIGHT);
    }

    private static boolean isProximityTable(NativeTable table) {
        return table.getType().equals(NativeTable.Type.PROXIMITY) || table.getType().equals(NativeTable.Type.REVERSE_PROXIMITY);
    }

    public Map<String, String> deriveRankProperties(int part) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        int i = part;
        for (NativeTable table : this.tables.values()) {
            if (FieldRankSettings.isFieldMatchTable(table)) {
                ret.put("nativeFieldMatch." + table.getType().getName() + "." + this.fieldName + ".part" + i, table.getName());
            }
            if (FieldRankSettings.isAttributeMatchTable(table)) {
                ret.put("nativeAttributeMatch." + table.getType().getName() + "." + this.fieldName + ".part" + i, table.getName());
            }
            if (FieldRankSettings.isProximityTable(table)) {
                ret.put("nativeProximity." + table.getType().getName() + "." + this.fieldName + ".part" + i, table.getName());
            }
            ++i;
        }
        return ret;
    }

    public String toString() {
        return "rank settings of field " + this.fieldName;
    }
}

