/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.searchlib.TranslogserverConfig;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.config.content.core.StorBucketmoverConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.config.storage.StorDevicesConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import com.yahoo.vespa.model.filedistribution.FileDistributorService;
import com.yahoo.vespa.model.search.NodeFlavorTuning;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchInterface;
import com.yahoo.vespa.model.search.TransactionLogServer;
import com.yahoo.vespa.model.search.Tuning;
import java.util.HashMap;
import java.util.Optional;
import org.w3c.dom.Element;

@RestartConfigs(value={ProtonConfig.class, MetricsmanagerConfig.class, TranslogserverConfig.class, StorDevicesConfig.class, StorFilestorConfig.class, StorBucketmoverConfig.class, StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class, LoadTypeConfig.class})
public class SearchNode
extends AbstractService
implements SearchInterface,
ProtonConfig.Producer,
FiledistributorrpcConfig.Producer,
MetricsmanagerConfig.Producer,
TranslogserverConfig.Producer {
    private static final long serialVersionUID = 1L;
    private final boolean flushOnShutdown;
    private NodeSpec nodeSpec;
    private int distributionKey;
    private final String clusterName;
    private TransactionLogServer tls;
    private AbstractService serviceLayerService;
    private final Optional<Tuning> tuning;
    private static final int RPC_PORT = 0;
    private static final int FS4_PORT = 1;
    private static final int HEALTH_PORT = 4;

    public static SearchNode create(AbstractConfigProducer parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Optional<Tuning> tuning) {
        return new SearchNode(parent, name, distributionKey, nodeSpec, clusterName, serviceLayerService, flushOnShutdown, tuning);
    }

    private SearchNode(AbstractConfigProducer parent, String name, int distributionKey, NodeSpec nodeSpec, String clusterName, AbstractService serviceLayerService, boolean flushOnShutdown, Optional<Tuning> tuning) {
        this(parent, name, nodeSpec, clusterName, flushOnShutdown, tuning);
        this.distributionKey = distributionKey;
        this.serviceLayerService = serviceLayerService;
        this.setPropertiesElastic(clusterName, distributionKey);
    }

    private SearchNode(AbstractConfigProducer parent, String name, NodeSpec nodeSpec, String clusterName, boolean flushOnShutdown, Optional<Tuning> tuning) {
        super(parent, name);
        this.nodeSpec = nodeSpec;
        this.clusterName = clusterName;
        this.flushOnShutdown = flushOnShutdown;
        this.portsMeta.on(0).tag("rpc").tag("rtc").tag("admin").tag("status");
        this.portsMeta.on(1).tag("fs4");
        this.portsMeta.on(4).tag("http").tag("json").tag("health").tag("state");
        this.monitorService();
        this.tuning = tuning;
    }

    private void setPropertiesElastic(String clusterName, int distributionKey) {
        this.setProp("index", distributionKey).setProp("clustertype", "search").setProp("clustername", clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private String getClusterConfigId() {
        return this.getParent().getConfigId();
    }

    private String getBaseDir() {
        return Defaults.getDefaults().underVespaHome("var/db/vespa/search/cluster." + this.getClusterName()) + "/n" + this.distributionKey;
    }

    public void updatePartition(int partitionId) {
        this.nodeSpec = new NodeSpec(this.nodeSpec.groupIndex(), partitionId);
    }

    @Override
    public NodeSpec getNodeSpec() {
        return this.nodeSpec;
    }

    @Override
    public int getPortCount() {
        return 5;
    }

    public int getRpcPort() {
        return this.getRelativePort(0);
    }

    @Override
    public int getHealthPort() {
        return this.getHttpPort();
    }

    @Override
    public String getServiceType() {
        return "searchnode";
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    @Override
    public String getDispatcherConnectSpec() {
        return "tcp/" + this.getHost().getHostName() + ":" + this.getDispatchPort();
    }

    public int getDispatchPort() {
        return this.getRelativePort(1);
    }

    public int getHttpPort() {
        return this.getRelativePort(4);
    }

    public void getConfig(TranslogserverConfig.Builder builder) {
        this.tls.getConfig(builder);
    }

    @Override
    public String toString() {
        return this.getHostName();
    }

    public TransactionLogServer getTransactionLogServer() {
        return this.tls;
    }

    public void setTls(TransactionLogServer tls) {
        this.tls = tls;
    }

    public AbstractService getServiceLayerService() {
        return this.serviceLayerService;
    }

    @Override
    public String getStartupCommand() {
        String startup = this.getEnvVariables() + "exec $ROOT/sbin/vespa-proton --identity " + this.getConfigId();
        if (this.serviceLayerService != null) {
            startup = startup + " --serviceidentity " + this.serviceLayerService.getConfigId();
        }
        return startup;
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        FileDistributorService fds;
        FileDistributionConfigProducer fileDistribution = this.getRoot().getFileDistributionConfigProducer();
        if (fileDistribution != null && (fds = fileDistribution.getFileDistributorService(this.getHost())) != null) {
            fds.getConfig(builder);
        }
    }

    public void getConfig(ProtonConfig.Builder builder) {
        builder.ptport(this.getDispatchPort()).rpcport(this.getRpcPort()).httpport(this.getHttpPort()).partition(this.getNodeSpec().partitionId()).clustername(this.getClusterName()).basedir(this.getBaseDir()).tlsspec("tcp/" + this.getHost().getHostName() + ":" + this.getTransactionLogServer().getTlsPort()).tlsconfigid(this.getConfigId()).slobrokconfigid(this.getClusterConfigId()).routingconfigid(this.getClusterConfigId()).distributionkey(this.getDistributionKey());
        if (this.isHostedVespa()) {
            builder.pruneremoveddocumentsage(349260.0);
        }
        if (this.getHostResource() != null && this.getHostResource().getFlavor().isPresent()) {
            new NodeFlavorTuning(this.getHostResource().getFlavor().get()).getConfig(builder);
            if (this.tuning.isPresent()) {
                this.tuning.get().getConfig(builder);
            }
        }
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        Monitoring point = this.getMonitoringService();
        if (point != null) {
            builder.snapshot(new MetricsmanagerConfig.Snapshot.Builder().periods(point.getIntervalSeconds()).periods(Integer.valueOf(300)));
        }
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("log").tags("logdefault"));
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        return Optional.ofNullable(this.flushOnShutdown ? Defaults.getDefaults().underVespaHome("bin/vespa-proton-cmd ") + this.getRpcPort() + " prepareRestart" : null);
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<SearchNode> {
        private final String name;
        private final NodeSpec nodeSpec;
        private final String clusterName;
        private final ContentNode contentNode;
        private final boolean flushOnShutdown;
        private final Optional<Tuning> tuning;

        public Builder(String name, NodeSpec nodeSpec, String clusterName, ContentNode node, boolean flushOnShutdown, Optional<Tuning> tuning) {
            this.name = name;
            this.nodeSpec = nodeSpec;
            this.clusterName = clusterName;
            this.contentNode = node;
            this.flushOnShutdown = flushOnShutdown;
            this.tuning = tuning;
        }

        @Override
        protected SearchNode doBuild(AbstractConfigProducer ancestor, Element producerSpec) {
            return new SearchNode(ancestor, this.name, this.contentNode.getDistributionKey(), this.nodeSpec, this.clusterName, this.contentNode, this.flushOnShutdown, this.tuning);
        }
    }
}

