/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.model.Host;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FileDistributor {
    private final FileRegistry fileRegistry;
    private final Map<FileReference, Set<Host>> filesToHosts = new LinkedHashMap<FileReference, Set<Host>>();

    public FileReference sendFileToHosts(String relativePath, Collection<Host> hosts) {
        FileReference reference = this.fileRegistry.addFile(relativePath);
        this.addToFilesToDistribute(reference, hosts);
        return reference;
    }

    public FileReference sendFileToHost(String relativePath, Host host) {
        return this.sendFileToHosts(relativePath, Arrays.asList(host));
    }

    private void addToFilesToDistribute(FileReference reference, Collection<Host> hosts) {
        Set<Host> oldHosts = this.getHosts(reference);
        oldHosts.addAll(hosts);
    }

    private Set<Host> getHosts(FileReference reference) {
        Set<Host> hosts = this.filesToHosts.get(reference);
        if (hosts == null) {
            hosts = new HashSet<Host>();
            this.filesToHosts.put(reference, hosts);
        }
        return hosts;
    }

    public FileDistributor(FileRegistry fileRegistry) {
        this.fileRegistry = fileRegistry;
    }

    public Set<FileReference> filesToSendToHost(Host host) {
        HashSet<FileReference> files = new HashSet<FileReference>();
        for (Map.Entry<FileReference, Set<Host>> e : this.filesToHosts.entrySet()) {
            if (!e.getValue().contains(host)) continue;
            files.add(e.getKey());
        }
        return files;
    }

    public Set<Host> getTargetHosts() {
        HashSet<Host> hosts = new HashSet<Host>();
        for (Set<Host> hostSubset : this.filesToHosts.values()) {
            hosts.addAll(hostSubset);
        }
        return hosts;
    }

    public Set<String> getTargetHostnames() {
        return this.getTargetHosts().stream().map(Host::getHostName).collect(Collectors.toSet());
    }

    public String fileSourceHost() {
        return this.fileRegistry.fileSourceHost();
    }

    public Set<FileReference> allFilesToSend() {
        return this.filesToHosts.keySet();
    }

    public void sendDeployedFiles(FileDistribution dbHandler) {
        String fileSourceHost = this.fileSourceHost();
        for (Host host : this.getTargetHosts()) {
            if (host.getHostName().equals(fileSourceHost)) continue;
            dbHandler.sendDeployedFiles(host.getHostName(), this.filesToSendToHost(host));
        }
        dbHandler.sendDeployedFiles(fileSourceHost, this.allFilesToSend());
        dbHandler.removeDeploymentsThatHaveDifferentApplicationId(this.getTargetHostnames());
    }

    public void reloadDeployFileDistributor(FileDistribution dbHandler) {
        dbHandler.reloadDeployFileDistributor();
    }

    private Set<String> union(Set<String> hosts, String ... additionalHosts) {
        HashSet<String> result = new HashSet<String>(hosts);
        result.addAll(Arrays.asList(additionalHosts));
        return result;
    }
}

