/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.config.application.Xml;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.path.Path;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.container.configserver.option.CloudConfigOptions;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigServerContainerModelBuilder
extends ContainerModelBuilder {
    private final CloudConfigOptions options;
    private static final String HOSTED_VESPA_INCLUDE_DIR = "hosted-vespa";

    public ConfigServerContainerModelBuilder(CloudConfigOptions options) {
        super(true, ContainerModelBuilder.Networking.enable);
        this.options = options;
    }

    @Override
    public void doBuild(ContainerModel model, Element spec, ConfigModelContext modelContext) {
        ApplicationPackage app = modelContext.getDeployState().getApplicationPackage();
        if (!app.getFiles(Path.fromString((String)HOSTED_VESPA_INCLUDE_DIR), ".xml").isEmpty()) {
            app.validateIncludeDir(HOSTED_VESPA_INCLUDE_DIR);
            List configModelElements = Xml.allElemsFromPath((ApplicationPackage)app, (String)HOSTED_VESPA_INCLUDE_DIR);
            this.mergeInto(spec, configModelElements);
        }
        ConfigserverCluster cluster = new ConfigserverCluster(modelContext.getParentProducer(), "configserver", this.options);
        super.doBuild(model, spec, modelContext.withParent(cluster));
        cluster.setContainerCluster(model.getCluster());
    }

    private void mergeInto(Element destination, List<Element> configModelElements) {
        for (Element jdiscElement : configModelElements) {
            for (Node child = jdiscElement.getFirstChild(); child != null; child = child.getNextSibling()) {
                Node copiedNode = destination.getOwnerDocument().importNode(child, true);
                destination.appendChild(copiedNode);
            }
        }
    }

    @Override
    protected void addDefaultComponents(ContainerCluster containerCluster) {
    }

    @Override
    protected void addDefaultHandlers(ContainerCluster containerCluster) {
        ConfigServerContainerModelBuilder.addDefaultHandlersExceptStatus(containerCluster);
    }
}

