/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.binaryprefix.BinaryScaledAmount;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.builder.xml.dom.BinaryScaledAmountParser;
import org.w3c.dom.Element;

public class DomFileDistributionOptionsBuilder {
    private static void throwExceptionForElementInFileDistribution(String subElement, String reason) {
        throw new RuntimeException("In element '" + subElement + "' contained in 'filedistribution': " + reason);
    }

    private static void callSetter(FileDistributionOptions options, String name, BinaryScaledAmount amount) {
        try {
            options.getClass().getMethod(name, BinaryScaledAmountParser.class).invoke((Object)options, amount);
        }
        catch (IllegalArgumentException e) {
            DomFileDistributionOptionsBuilder.throwExceptionForElementInFileDistribution(name, e.getMessage());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void setIfPresent(FileDistributionOptions options, String name, Element fileDistributionElement) {
        try {
            Element optionElement = XML.getChild((Element)fileDistributionElement, (String)name);
            if (optionElement != null) {
                String valueString = XML.getValue((Element)optionElement);
                BinaryScaledAmount amount = BinaryScaledAmountParser.parse(valueString);
                DomFileDistributionOptionsBuilder.callSetter(options, name, amount);
            }
        }
        catch (NumberFormatException e) {
            DomFileDistributionOptionsBuilder.throwExceptionForElementInFileDistribution(name, "Expected a valid number. (Message = " + e.getMessage() + ").");
        }
    }

    public FileDistributionOptions build(Element fileDistributionElement) {
        FileDistributionOptions options = FileDistributionOptions.defaultOptions();
        if (fileDistributionElement != null) {
            DomFileDistributionOptionsBuilder.setIfPresent(options, "uploadbitrate", fileDistributionElement);
            DomFileDistributionOptionsBuilder.setIfPresent(options, "downloadbitrate", fileDistributionElement);
        }
        return options;
    }
}

