/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.engines;

import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.search.SearchNode;

public class RPCEngine
extends PersistenceEngine {
    private SearchNode searchNode;

    public RPCEngine(StorageNode parent) {
        super(parent, "provider");
    }

    public RPCEngine(StorageNode parent, SearchNode searchNode) {
        super(parent, "provider");
        this.searchNode = searchNode;
    }

    public void getConfig(StorServerConfig.Builder builder) {
        StorServerConfig.Persistence_provider.Builder provider = new StorServerConfig.Persistence_provider.Builder();
        provider.type(StorServerConfig.Persistence_provider.Type.Enum.RPC);
        if (this.searchNode != null) {
            provider.rpc(new StorServerConfig.Persistence_provider.Rpc.Builder().connectspec("tcp/localhost:" + this.searchNode.getPersistenceProviderRpcPort()));
        }
        builder.persistence_provider(provider);
    }

    public static class Factory
    implements PersistenceEngine.PersistenceFactory {
        @Override
        public PersistenceEngine create(StorageNode storageNode, StorageGroup parentGroup, ModelElement storageNodeElement) {
            return new RPCEngine(storageNode);
        }

        @Override
        public boolean supportRevert() {
            return false;
        }

        @Override
        public boolean enableMultiLevelSplitting() {
            return false;
        }

        @Override
        public ContentCluster.DistributionMode getDefaultDistributionMode() {
            return ContentCluster.DistributionMode.LOOSE;
        }
    }
}

