/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;

public class Redundancy
implements StorDistributionConfig.Producer,
ProtonConfig.Producer {
    private final int initialRedundancy;
    private final int finalRedundancy;
    private final int readyCopies;
    private int implicitGroups = 1;
    private int explicitGroups = 1;
    private int totalNodes = 0;

    public Redundancy(int initialRedundancy, int finalRedundancy, int readyCopies) {
        this.initialRedundancy = initialRedundancy;
        this.finalRedundancy = finalRedundancy;
        this.readyCopies = readyCopies;
    }

    public void setTotalNodes(int totalNodes) {
        this.totalNodes = totalNodes;
    }

    public void setImplicitGroups(int implicitGroups) {
        this.implicitGroups = implicitGroups;
    }

    public void setExplicitGroups(int explicitGroups) {
        this.explicitGroups = explicitGroups;
    }

    public int initialRedundancy() {
        return this.initialRedundancy;
    }

    public int finalRedundancy() {
        return this.finalRedundancy;
    }

    public int readyCopies() {
        return this.readyCopies;
    }

    public int totalNodes() {
        return this.totalNodes;
    }

    public int effectiveInitialRedundancy() {
        return Math.min(this.totalNodes, this.initialRedundancy * this.implicitGroups);
    }

    public int effectiveFinalRedundancy() {
        return Math.min(this.totalNodes, this.finalRedundancy * this.implicitGroups);
    }

    public int effectiveReadyCopies() {
        return Math.min(this.totalNodes, this.readyCopies * this.implicitGroups);
    }

    public boolean isEffectivelyGloballyDistributed() {
        return this.totalNodes == this.effectiveFinalRedundancy();
    }

    public void getConfig(StorDistributionConfig.Builder builder) {
        builder.initial_redundancy(this.effectiveInitialRedundancy());
        builder.redundancy(this.effectiveFinalRedundancy());
        builder.ready_copies(this.effectiveReadyCopies());
    }

    public void getConfig(ProtonConfig.Builder builder) {
        ProtonConfig.Distribution.Builder distBuilder = new ProtonConfig.Distribution.Builder();
        distBuilder.redundancy((long)(this.finalRedundancy / this.explicitGroups));
        distBuilder.searchablecopies((long)(this.readyCopies / (this.explicitGroups * this.implicitGroups)));
        builder.distribution(distBuilder);
    }
}

