/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search.searchchain;

import com.yahoo.binaryprefix.BinaryPrefix;
import com.yahoo.binaryprefix.BinaryScaledAmount;
import com.yahoo.component.chain.model.ChainSpecification;
import com.yahoo.search.cache.QrBinaryCacheConfig;
import com.yahoo.search.cache.QrBinaryCacheRegionConfig;
import com.yahoo.search.federation.ProviderConfig;
import com.yahoo.search.searchchain.model.federation.FederationOptions;
import com.yahoo.search.searchchain.model.federation.HttpProviderSpec;
import com.yahoo.vespa.model.container.search.searchchain.Provider;
import java.util.ArrayList;
import java.util.List;

public class HttpProvider
extends Provider
implements ProviderConfig.Producer,
QrBinaryCacheConfig.Producer,
QrBinaryCacheRegionConfig.Producer {
    private final HttpProviderSpec providerSpec;
    private BinaryScaledAmount cacheSize;

    public double getCacheWeight() {
        return this.providerSpec.cacheWeight;
    }

    public void setCacheSize(BinaryScaledAmount cacheSize) {
        this.cacheSize = cacheSize;
    }

    public HttpProvider(ChainSpecification specWithoutInnerSearchers, FederationOptions federationOptions, HttpProviderSpec providerSpec) {
        super(specWithoutInnerSearchers, federationOptions);
        this.providerSpec = providerSpec;
    }

    public void getConfig(ProviderConfig.Builder builder) {
        if (this.providerSpec.path != null) {
            builder.path(this.providerSpec.path);
        }
        if (this.providerSpec.connectionParameters.readTimeout != null) {
            builder.readTimeout(this.providerSpec.connectionParameters.readTimeout.doubleValue());
        }
        if (this.providerSpec.connectionParameters.connectionTimeout != null) {
            builder.connectionTimeout(this.providerSpec.connectionParameters.connectionTimeout.doubleValue());
        }
        if (this.providerSpec.connectionParameters.connectionPoolTimeout != null) {
            builder.connectionPoolTimeout(this.providerSpec.connectionParameters.connectionPoolTimeout.doubleValue());
        }
        if (this.providerSpec.connectionParameters.retries != null) {
            builder.retries(this.providerSpec.connectionParameters.retries.intValue());
        }
        builder.node(HttpProvider.getNodes(this.providerSpec.nodes));
        if (this.providerSpec.ycaApplicationId != null) {
            builder.yca(HttpProvider.getCertificate(this.providerSpec));
        }
    }

    private static ProviderConfig.Yca.Builder getCertificate(HttpProviderSpec providerSpec) {
        ProviderConfig.Yca.Builder certificate = new ProviderConfig.Yca.Builder().applicationId(providerSpec.ycaApplicationId);
        if (providerSpec.ycaProxy != null) {
            certificate.useProxy(true);
            if (providerSpec.ycaProxy.host != null) {
                certificate.host(providerSpec.ycaProxy.host).port(providerSpec.ycaProxy.port);
            }
        }
        if (providerSpec.ycaCertificateTtl != null) {
            certificate.ttl(providerSpec.ycaCertificateTtl.intValue());
        }
        if (providerSpec.ycaRetryWait != null) {
            certificate.ttl(providerSpec.ycaRetryWait.intValue());
        }
        return certificate;
    }

    private static List<ProviderConfig.Node.Builder> getNodes(List<HttpProviderSpec.Node> nodeSpecs) {
        ArrayList<ProviderConfig.Node.Builder> nodes = new ArrayList<ProviderConfig.Node.Builder>();
        for (HttpProviderSpec.Node node : nodeSpecs) {
            nodes.add(new ProviderConfig.Node.Builder().host(node.host).port(node.port));
        }
        return nodes;
    }

    public int cacheSizeMB() {
        return this.providerSpec.cacheSizeMB != null ? this.providerSpec.cacheSizeMB : (int)this.cacheSize.as(BinaryPrefix.mega);
    }

    public void getConfig(QrBinaryCacheConfig.Builder builder) {
        builder.cache_size(this.cacheSizeMB());
    }

    public void getConfig(QrBinaryCacheRegionConfig.Builder builder) {
        builder.region_size(this.cacheSizeMB());
    }
}

