/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class DomMetricBuilderHelper {
    private static final String LEGACY_DEFAULT_CONSUMER_ID = "yamas";

    protected static Map<String, MetricsConsumer> buildMetricsConsumers(Element spec) {
        LinkedHashMap<String, MetricsConsumer> metricsConsumers = new LinkedHashMap<String, MetricsConsumer>();
        List consumersElem = XML.getChildren((Element)spec, (String)"consumer");
        for (Element consumer : consumersElem) {
            String consumerName = DomMetricBuilderHelper.getConsumerName(consumer);
            LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
            List metricsEl = XML.getChildren((Element)consumer, (String)"metric");
            if (metricsEl != null) {
                for (Element metric : metricsEl) {
                    String metricName = metric.getAttribute("name");
                    String outputName = metric.getAttribute("output-name");
                    metrics.add(new Metric(metricName, outputName));
                }
            }
            MetricsConsumer metricsConsumer = new MetricsConsumer(consumerName, new MetricSet(DomMetricBuilderHelper.metricSetId(consumerName), metrics));
            metricsConsumers.put(consumerName, metricsConsumer);
        }
        return metricsConsumers;
    }

    private static String getConsumerName(Element consumerElement) {
        String givenName = consumerElement.getAttribute("name");
        if (givenName.equals(LEGACY_DEFAULT_CONSUMER_ID)) {
            return "Vespa";
        }
        return givenName;
    }

    private static String metricSetId(String consumerName) {
        return "legacy-user-metrics-" + consumerName;
    }
}

