/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.google.common.collect.ImmutableSet;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import java.util.Collection;

public class SystemMetrics {
    public static final String CPU_UTIL = "cpu.util";
    public static final String DISK_LIMIT = "disk.limit";
    public static final String DISK_USED = "disk.used";
    public static final String DISK_UTIL = "disk.util";
    public static final String MEM_LIMIT = "mem.limit";
    public static final String MEM_USED = "mem.used";
    public static final String MEM_UTIL = "mem.util";
    public static final MetricSet systemMetricSet = SystemMetrics.createSystemMetricSet();

    private static MetricSet createSystemMetricSet() {
        ImmutableSet dockerNodeMetrics = ImmutableSet.of((Object)new Metric(CPU_UTIL), (Object)new Metric(DISK_LIMIT), (Object)new Metric(DISK_USED), (Object)new Metric(DISK_UTIL), (Object)new Metric(MEM_LIMIT), (Object)new Metric(MEM_USED), (Object[])new Metric[]{new Metric(MEM_UTIL)});
        ImmutableSet nonDockerNodeMetrics = ImmutableSet.of((Object)new Metric("cpu.busy.pct", CPU_UTIL), (Object)new Metric("mem.used.pct", MEM_UTIL), (Object)new Metric("mem.active.kb", MEM_USED), (Object)new Metric("mem.total.kb", MEM_LIMIT), (Object)new Metric("used.kb", DISK_USED));
        ImmutableSet systemMetrics = ImmutableSet.builder().addAll((Iterable)dockerNodeMetrics).addAll((Iterable)nonDockerNodeMetrics).build();
        return new MetricSet("system", (Collection<Metric>)systemMetrics);
    }
}

