/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Iterator;

public class IndexSettingsNonFieldNames
extends Processor {
    public IndexSettingsNonFieldNames(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            boolean fieldNameUsed = false;
            Iterator<String> i = field.getFieldNameAsIterator();
            while (i.hasNext()) {
                String iName = i.next();
                if (!iName.equals(field.getName())) continue;
                fieldNameUsed = true;
            }
            if (fieldNameUsed) continue;
            for (Index index : field.getIndices().values()) {
                if (!index.getName().equals(field.getName())) continue;
                throw new IllegalArgumentException("Error in " + field + " in " + this.search + ": When all index names differ from field name, index parameter settings must specify index name explicitly.");
            }
        }
    }
}

