/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.TensorDataType;
import com.yahoo.searchdefinition.DocumentReference;
import com.yahoo.searchdefinition.DocumentReferences;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.TemporaryImportedField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ImportedFieldsResolver
extends Processor {
    private final Map<String, ImportedField> importedFields = new LinkedHashMap<String, ImportedField>();
    private final Optional<DocumentReferences> references;

    public ImportedFieldsResolver(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
        this.references = search.getDocument().getDocumentReferences();
    }

    @Override
    public void process() {
        this.search.temporaryImportedFields().get().fields().forEach((name, field) -> this.resolveImportedField((TemporaryImportedField)field));
        this.search.setImportedFields(new ImportedFields(this.importedFields));
    }

    private void resolveImportedField(TemporaryImportedField importedField) {
        DocumentReference reference = this.validateDocumentReference(importedField);
        SDField targetField = this.validateTargetField(importedField, reference);
        this.importedFields.put(importedField.fieldName(), new ImportedField(importedField.fieldName(), reference, targetField));
    }

    private DocumentReference validateDocumentReference(TemporaryImportedField importedField) {
        String referenceFieldName = importedField.referenceFieldName();
        DocumentReference reference = this.references.get().referenceMap().get(referenceFieldName);
        if (reference == null) {
            this.fail(importedField, "Reference field '" + referenceFieldName + "' not found");
        }
        return reference;
    }

    private SDField validateTargetField(TemporaryImportedField importedField, DocumentReference reference) {
        SDField targetField;
        String targetFieldName = importedField.targetFieldName();
        Search targetSearch = reference.targetSearch();
        if (ImportedFieldsResolver.isImportedField(targetSearch, targetFieldName)) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Is an imported field. Not supported");
        }
        if ((targetField = targetSearch.getConcreteField(targetFieldName)) == null) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Not found");
        } else if (!targetField.doesAttributing()) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Is not an attribute field. Only attribute fields supported");
        } else if (targetField.doesIndexing()) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Is an index field. Not supported");
        } else if (targetField.getDataType() instanceof TensorDataType) {
            this.fail(importedField, ImportedFieldsResolver.targetFieldAsString(targetFieldName, reference) + ": Is of type 'tensor'. Not supported");
        }
        return targetField;
    }

    private static boolean isImportedField(Search targetSearch, String targetFieldName) {
        return targetSearch.importedFields().isPresent() && targetSearch.importedFields().get().fields().containsKey(targetFieldName);
    }

    private static String targetFieldAsString(String targetFieldName, DocumentReference reference) {
        return "Field '" + targetFieldName + "' via reference field '" + reference.referenceField().getName() + "'";
    }

    private void fail(TemporaryImportedField importedField, String msg) {
        throw new IllegalArgumentException("For search '" + this.search.getName() + "', import field '" + importedField.fieldName() + "': " + msg);
    }
}

