/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AttributeProperties
extends Processor {
    public AttributeProperties(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            String fieldName = field.getName();
            for (Attribute attribute : field.getAttributes().values()) {
                if (AttributeProperties.attributeCreated(field, attribute.getName())) continue;
                boolean created = false;
                for (SDField f : this.search.allConcreteFields()) {
                    if (f.getName().equals(fieldName) || !AttributeProperties.attributeCreated(f, attribute.getName())) continue;
                    created = true;
                    break;
                }
                if (created) continue;
                throw new IllegalArgumentException("Attribute '" + attribute.getName() + "' in field '" + field.getName() + "' is not created by the indexing statement");
            }
        }
    }

    static boolean attributeCreated(SDField field, String attributeName) {
        if (!field.doesAttributing()) {
            return false;
        }
        for (Attribute attribute : field.getAttributes().values()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }
}

