/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.parser;

import com.yahoo.compress.CompressionType;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.CompressionConfig;
import com.yahoo.document.DataType;
import com.yahoo.document.DataTypeName;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.document.ReferenceDataType;
import com.yahoo.document.TemporaryStructuredDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.documentmodel.VespaDocumentType;
import com.yahoo.language.Linguistics;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.UnproperSearch;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.document.Sorting;
import com.yahoo.searchdefinition.document.Stemming;
import com.yahoo.searchdefinition.document.TemporaryImportedField;
import com.yahoo.searchdefinition.document.TemporarySDField;
import com.yahoo.searchdefinition.document.annotation.SDAnnotationType;
import com.yahoo.searchdefinition.document.annotation.TemporaryAnnotationReferenceDataType;
import com.yahoo.searchdefinition.fieldoperation.AliasOperation;
import com.yahoo.searchdefinition.fieldoperation.AttributeOperation;
import com.yahoo.searchdefinition.fieldoperation.BoldingOperation;
import com.yahoo.searchdefinition.fieldoperation.FieldOperationContainer;
import com.yahoo.searchdefinition.fieldoperation.IdOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexingOperation;
import com.yahoo.searchdefinition.fieldoperation.IndexingRewriteOperation;
import com.yahoo.searchdefinition.fieldoperation.MatchOperation;
import com.yahoo.searchdefinition.fieldoperation.NormalizingOperation;
import com.yahoo.searchdefinition.fieldoperation.QueryCommandOperation;
import com.yahoo.searchdefinition.fieldoperation.RankOperation;
import com.yahoo.searchdefinition.fieldoperation.RankTypeOperation;
import com.yahoo.searchdefinition.fieldoperation.SortingOperation;
import com.yahoo.searchdefinition.fieldoperation.StemmingOperation;
import com.yahoo.searchdefinition.fieldoperation.StructFieldOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldLongOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryInFieldShortOperation;
import com.yahoo.searchdefinition.fieldoperation.SummaryToOperation;
import com.yahoo.searchdefinition.fieldoperation.WeightOperation;
import com.yahoo.searchdefinition.fieldoperation.WeightedSetOperation;
import com.yahoo.searchdefinition.parser.CharStream;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.searchdefinition.parser.SDParserConstants;
import com.yahoo.searchdefinition.parser.SDParserTokenManager;
import com.yahoo.searchdefinition.parser.SimpleCharStream;
import com.yahoo.searchdefinition.parser.Token;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;

public class SDParser
implements SDParserConstants {
    private DocumentTypeManager docMan = null;
    private ApplicationPackage app = MockApplicationPackage.createEmpty();
    private DeployLogger deployLogger = new BaseDeployLogger();
    private RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
    public SDParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[169];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SDParser(String input, DeployLogger deployLogger) {
        this(new SimpleCharStream(input), deployLogger);
    }

    public SDParser(SimpleCharStream stream, DeployLogger deployLogger) {
        this(stream);
        this.deployLogger = deployLogger;
    }

    public SDParser(SimpleCharStream stream, DeployLogger deployLogger, ApplicationPackage applicationPackage, RankProfileRegistry rankProfileRegistry) {
        this(stream);
        this.deployLogger = deployLogger;
        this.app = applicationPackage;
        this.rankProfileRegistry = rankProfileRegistry;
    }

    private IndexingOperation newIndexingOperation(boolean multiline) throws ParseException {
        return this.newIndexingOperation(multiline, (Linguistics)new SimpleLinguistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexingOperation newIndexingOperation(boolean multiline, Linguistics linguistics) throws ParseException {
        SimpleCharStream input = (SimpleCharStream)this.token_source.input_stream;
        if (this.token.next != null) {
            input.backup(this.token.next.image.length());
        }
        try {
            IndexingOperation indexingOperation = IndexingOperation.fromStream(input, multiline, linguistics);
            return indexingOperation;
        }
        finally {
            this.token.next = null;
            this.jj_ntk = -1;
        }
    }

    private FeatureList getFeatureList(String image) throws ParseException {
        try {
            return new FeatureList(image);
        }
        catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
            throw (ParseException)new ParseException("Could not parse feature list '" + image + "' at line " + this.token_source.input_stream.getBeginLine() + ", column " + this.token_source.input_stream.getBeginColumn() + ".").initCause(e);
        }
    }

    private void setCompressionThreshold(CompressionConfig cfg, int val) {
        cfg.threshold = val;
    }

    private void setCompressionLevel(CompressionConfig cfg, int val) {
        cfg.compressionLevel = val;
    }

    public final Search search(DocumentTypeManager docMan, String dir) throws ParseException {
        Search search;
        this.docMan = docMan;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                search = this.rootSearch(dir);
                break;
            }
            case 0: 
            case 15: {
                search = this.rootDocument(dir);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return search;
    }

    public final Search rootSearch(String dir) throws ParseException {
        this.jj_consume_token(8);
        String name = this.identifier();
        if (!name.matches("[a-zA-Z_][a-zA-Z_:0-9]*")) {
            this.deployLogger.log(Level.WARNING, name + " can not be used in YQL+ expressions.");
        }
        Search search = new Search(name, this.app);
        this.rankProfileRegistry.addRankProfile(new DefaultRankProfile(search, this.rankProfileRegistry));
        this.rankProfileRegistry.addRankProfile(new UnrankedRankProfile(search, this.rankProfileRegistry));
        this.lbrace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 15: 
                case 16: 
                case 18: 
                case 20: 
                case 22: 
                case 26: 
                case 30: 
                case 41: 
                case 42: 
                case 48: 
                case 72: 
                case 115: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            this.rootSearchItem(search);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                        continue block9;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block11;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        return search;
    }

    public final Object rootSearchItem(Search search) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.document(search);
                break;
            }
            case 26: 
            case 48: {
                this.documentSummary(search);
                break;
            }
            case 18: {
                this.field(null, search);
                break;
            }
            case 30: {
                this.index(search, null);
                break;
            }
            case 41: {
                this.rankingConstant(search);
                break;
            }
            case 42: {
                this.rankProfile(search);
                break;
            }
            case 72: {
                this.searchStemming(search);
                break;
            }
            case 115: {
                this.useDocument(search);
                break;
            }
            case 16: {
                this.structOutside(search);
                break;
            }
            case 6: {
                this.annotationOutside(search);
                break;
            }
            case 20: {
                this.fieldSet(search);
                break;
            }
            case 22: {
                this.importField(search);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Search rootDocument(String dir) throws ParseException {
        UnproperSearch search = new UnproperSearch();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            this.rootDocumentItem(search);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(0);
        return search;
    }

    public final Object rootDocumentItem(Search search) throws ParseException {
        this.namedDocument(search);
        return null;
    }

    public final void useDocument(Search search) throws ParseException {
        this.jj_consume_token(115);
        this.jj_consume_token(118);
        this.identifier();
    }

    public final void document(Search search) throws ParseException {
        String name = search.getName();
        this.jj_consume_token(15);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(5);
        }
        SDDocumentType document = new SDDocumentType(name, search);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(116);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(5);
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 16: 
                case 18: 
                case 75: 
                case 76: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block24;
                }
            }
            this.documentBody(document, search);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        continue block24;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        search.addDocument(document);
    }

    public final void namedDocument(Search search) throws ParseException {
        this.jj_consume_token(15);
        String name = this.identifier();
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        SDDocumentType document = new SDDocumentType(name, search);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.jj_consume_token(116);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(5);
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 16: 
                case 18: 
                case 75: 
                case 76: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block21;
                }
            }
            this.documentBody(document, search);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[20] = this.jj_gen;
                        continue block21;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        search.addDocument(document);
    }

    public final Object documentBody(SDDocumentType document, Search search) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.annotation(search, document);
                break;
            }
            case 111: {
                this.compression(document, null);
                break;
            }
            case 76: {
                this.headercfg(document);
                break;
            }
            case 75: {
                this.bodycfg(document);
                break;
            }
            case 16: {
                this.structInside(document, search);
                break;
            }
            case 18: {
                this.field(document, search);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void headercfg(SDDocumentType document) throws ParseException {
        this.jj_consume_token(76);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                this.compression(document, "header");
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(117);
    }

    public final void bodycfg(SDDocumentType document) throws ParseException {
        this.jj_consume_token(75);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 111: {
                this.compression(document, "body");
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(117);
    }

    public final void compression(SDDocumentType document, String name) throws ParseException {
        CompressionConfig cfg = new CompressionConfig(CompressionType.LZ4);
        this.jj_consume_token(111);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 112: 
                case 113: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block6;
                }
            }
            cfg = this.compressionItem(cfg);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[27] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        if (name == null || name.equals("header")) {
            document.getDocumentType().getHeaderType().setCompressionConfig(cfg);
        }
        if (name == null || name.equals("body")) {
            document.getDocumentType().getBodyType().setCompressionConfig(cfg);
        }
    }

    public final CompressionConfig compressionItem(CompressionConfig cfg) throws ParseException {
        int val = -1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                this.jj_consume_token(118);
                this.jj_consume_token(114);
                cfg = new CompressionConfig(CompressionType.LZ4, cfg.compressionLevel, cfg.threshold);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                this.jj_consume_token(118);
                val = this.integer();
                this.setCompressionThreshold(cfg, val);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                this.jj_consume_token(118);
                val = this.integer();
                this.setCompressionLevel(cfg, val);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cfg;
    }

    public final void inheritsDocument(SDDocumentType document) throws ParseException {
        this.jj_consume_token(17);
        String name = this.identifier();
        document.inherit(new DataTypeName(name));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(120);
            name = this.identifier();
            document.inherit(new DataTypeName(name));
        }
    }

    public final void field(SDDocumentType document, Search search) throws ParseException {
        this.jj_consume_token(18);
        String name = this.identifier();
        this.jj_consume_token(29);
        DataType type = this.dataType();
        if (name != null && Search.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        TemporarySDField field = new TemporarySDField(name, type, true, document);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 24: 
                case 25: 
                case 27: 
                case 28: 
                case 30: 
                case 48: 
                case 57: 
                case 58: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 92: 
                case 94: 
                case 122: {
                    break;
                }
                default: {
                    this.jj_la1[30] = this.jj_gen;
                    break block6;
                }
            }
            this.fieldBody(field, search, document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        if (document != null) {
            document.addField(field);
        } else {
            search.addExtraField(field);
        }
    }

    public final void fieldSet(Search search) throws ParseException {
        this.jj_consume_token(20);
        String name = this.identifier();
        this.lbrace();
        block6: while (true) {
            this.fieldSetItem(name, search);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 83: 
                case 85: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[33] = this.jj_gen;
        this.jj_consume_token(117);
    }

    public final void fieldSetItem(String setName, Search search) throws ParseException {
        SDField matchSettings = new SDField(setName, (DataType)DataType.STRING);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                this.jj_consume_token(19);
                this.jj_consume_token(118);
                String field = this.identifier();
                search.fieldSets().addUserFieldSetItem(setName, field);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            break;
                        }
                        default: {
                            this.jj_la1[34] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(120);
                    field = this.identifier();
                    search.fieldSets().addUserFieldSetItem(setName, field);
                }
            }
            case 83: {
                String queryCommand;
                this.jj_consume_token(83);
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 115: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 157: 
                    case 158: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 177: {
                        queryCommand = this.identifier();
                        break;
                    }
                    case 168: {
                        queryCommand = this.quotedString();
                        break;
                    }
                    default: {
                        this.jj_la1[35] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                search.fieldSets().userFieldSets().get(setName).queryCommands().add(queryCommand);
                break;
            }
            case 85: {
                this.match(matchSettings);
                matchSettings.applyOperations();
                search.fieldSets().userFieldSets().get(setName).setMatching(matchSettings.getMatching());
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void annotationOutside(Search search) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        SDAnnotationType type = new SDAnnotationType(name.trim());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.lbrace();
        type = this.annotationBody(search, type);
        this.jj_consume_token(117);
        if (search.getDocument() == null) {
            throw new IllegalArgumentException("Can't add annotation '" + name + "' to a document type, define a document type first or declare the annotation inside of one.");
        }
        search.addAnnotation(type);
    }

    public final void annotation(Search search, SDDocumentType document) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        SDAnnotationType type = new SDAnnotationType(name.trim());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        this.lbrace();
        type = this.annotationBody(search, type);
        this.jj_consume_token(117);
        document.addAnnotation(type);
    }

    public final SDAnnotationType annotationBody(Search search, SDAnnotationType type) throws ParseException {
        SDDocumentType struct = new SDDocumentType("annotation." + type.getName(), search);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        if (struct.getFieldCount() > 0) {
            type = new SDAnnotationType(type.getName(), struct, type.getInherits());
            struct.setStruct(null);
        }
        return type;
    }

    public final void inheritsAnnotation(SDAnnotationType annotation) throws ParseException {
        this.jj_consume_token(17);
        String name = this.identifier();
        annotation.inherit(name);
    }

    public final void structInside(SDDocumentType document, Search search) throws ParseException {
        SDDocumentType struct = this.structDefinition(search, document);
        document.addType(struct);
    }

    public final void structOutside(Search search) throws ParseException {
        SDDocumentType struct = this.structDefinition(search, search.getDocument());
        search.addType(struct);
    }

    public final SDDocumentType structDefinition(Search search, SDDocumentType repo) throws ParseException {
        this.jj_consume_token(16);
        String name = this.identifier();
        SDDocumentType struct = new SDDocumentType(name, search);
        this.lbrace();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block8;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        continue block8;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        try {
            this.docMan.getDataType(name);
            throw new ParseException("Reserved name '" + name + "' can not be used to declare a struct.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (repo == null) {
                throw new IllegalArgumentException("Can't add struct '" + name + "' to a document type, define a document type first or declare the struct inside of one.");
            }
            SDDocumentType sdtype = repo.getOwnedType(struct.getDocumentName());
            DataType stype = sdtype != null ? sdtype.getStruct() : TemporaryStructuredDataType.create((String)struct.getName());
            struct.setStruct(stype);
            return struct;
        }
    }

    public final DataType dataType() throws ParseException {
        String typeName = null;
        boolean isArrayOldStyle = false;
        DataType mapType = null;
        DataType arrayType = null;
        DataType wsetType = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(121);
            this.jj_consume_token(175);
            arrayType = this.dataType();
            this.jj_consume_token(176);
            return DataType.getArray((DataType)arrayType);
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(122);
            this.jj_consume_token(175);
            wsetType = this.dataType();
            this.jj_consume_token(176);
            return DataType.getWeightedSet((DataType)wsetType);
        }
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            mapType = this.mapDataType();
            return mapType;
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            mapType = this.annotationRefDataType();
            return mapType;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            TensorType tensorType = this.tensorType("Field type");
            return DataType.getTensor((TensorType)tensorType);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(124);
            this.jj_consume_token(175);
            TemporaryStructuredDataType referenceType = this.referenceType();
            this.jj_consume_token(176);
            return ReferenceDataType.createWithInferredId((TemporaryStructuredDataType)referenceType);
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                typeName = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 179: {
                        this.jj_consume_token(179);
                        isArrayOldStyle = true;
                        break block0;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataType type = VespaDocumentType.INSTANCE.getDataType(typeName);
        if (type == null) {
            type = TemporaryStructuredDataType.create((String)typeName);
        }
        if (isArrayOldStyle) {
            this.deployLogger.log(Level.WARNING, "Data type syntax '" + typeName + "[]' is deprecated, use 'array<" + typeName + ">' instead.");
            type = DataType.getArray((DataType)type);
        }
        if ("tag".equalsIgnoreCase(typeName) && type instanceof WeightedSetDataType) {
            ((WeightedSetDataType)type).setTag(true);
        }
        return type;
    }

    public final TemporaryStructuredDataType referenceType() throws ParseException {
        String documentName = this.identifier();
        return TemporaryStructuredDataType.create((String)documentName);
    }

    public final DataType annotationRefDataType() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(175);
        String targetName = this.identifier();
        this.jj_consume_token(176);
        return new TemporaryAnnotationReferenceDataType(targetName);
    }

    public final DataType mapDataType() throws ParseException {
        this.jj_consume_token(123);
        this.jj_consume_token(175);
        DataType keyType = this.dataType();
        this.jj_consume_token(120);
        DataType valType = this.dataType();
        this.jj_consume_token(176);
        return DataType.getMap((DataType)keyType, (DataType)valType);
    }

    public final DataType wildCardType() throws ParseException {
        this.jj_consume_token(125);
        return DataType.NONE;
    }

    public final void structFieldDefinition(SDDocumentType struct) throws ParseException {
        this.jj_consume_token(18);
        String name = this.identifier();
        this.jj_consume_token(29);
        DataType type = this.dataType();
        if (name != null && Search.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        TemporarySDField field = new TemporarySDField(name, type, true, struct);
        struct.addField(field);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 94: {
                this.id(field, struct);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[47] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: {
                    break;
                }
                default: {
                    this.jj_la1[49] = this.jj_gen;
                    break block13;
                }
            }
            this.match(field);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
    }

    public final void structField(FieldOperationContainer field, Search search, SDDocumentType document) throws ParseException {
        this.jj_consume_token(21);
        String name = this.identifier();
        if (name != null && Search.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        StructFieldOperation structFieldOp = new StructFieldOperation(name);
        field.addOperation(structFieldOp);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 24: 
                case 25: 
                case 48: 
                case 83: 
                case 85: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldBody(structFieldOp, search, document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
    }

    public final String fieldBody(SDField field, Search search, SDDocumentType document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: {
                this.alias(field);
                break;
            }
            case 57: {
                this.attribute(field);
                break;
            }
            case 75: {
                this.body(field);
                break;
            }
            case 74: {
                this.bolding(field);
                break;
            }
            case 72: {
                this.fieldStemming(field);
                break;
            }
            case 76: {
                this.header(field);
                break;
            }
            case 94: {
                this.id(field, document);
                break;
            }
            case 48: {
                this.summaryInField(field);
                break;
            }
            case 30: {
                this.index(search, field);
                break;
            }
            case 24: {
                this.indexing(field);
                break;
            }
            case 92: {
                this.indexingRewrite(field);
                break;
            }
            case 85: {
                this.match(field);
                break;
            }
            case 73: {
                this.normalizing(field);
                break;
            }
            case 83: {
                this.queryCommand(field);
                break;
            }
            case 86: {
                this.rank(field);
                break;
            }
            case 27: {
                this.rankType(field);
                break;
            }
            case 58: {
                this.sorting(field, field.getName());
                break;
            }
            case 21: {
                this.structField(field, search, document);
                break;
            }
            case 25: {
                this.summaryTo(field);
                break;
            }
            case 28: {
                this.weight(field);
                break;
            }
            case 122: {
                this.weightedset(field);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final String structFieldBody(FieldOperationContainer field, Search search, SDDocumentType document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: {
                this.summaryInField(field);
                break;
            }
            case 24: {
                this.indexing(field);
                break;
            }
            case 85: {
                this.match(field);
                break;
            }
            case 83: {
                this.queryCommand(field);
                break;
            }
            case 21: {
                this.structField(field, search, document);
                break;
            }
            case 25: {
                this.summaryTo(field);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object indexing(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.indexingOperation(field, false);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.indexingOperation(field, true);
            }
        }
        return null;
    }

    public final void indexingOperation(FieldOperationContainer field, boolean multiLine) throws ParseException {
        field.addOperation(this.newIndexingOperation(multiLine));
    }

    public final void summaryTo(FieldOperationContainer field) throws ParseException {
        SummaryToOperation op = new SummaryToOperation();
        String name = field.getName();
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        this.jj_consume_token(118);
        String destination = this.identifier();
        op.setName(name);
        op.addDestination(destination);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(120);
            destination = this.identifier();
            op.addDestination(destination);
        }
        field.addOperation(op);
    }

    public final void weight(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(118);
        int num = this.integer();
        WeightOperation op = new WeightOperation();
        op.setWeight(num);
        field.addOperation(op);
    }

    public final Object weightedset(FieldOperationContainer field) throws ParseException {
        WeightedSetOperation op = new WeightedSetOperation();
        this.jj_consume_token(122);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.weightedsetBody(op);
                break;
            }
            case 5: 
            case 116: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 126: 
                        case 127: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.weightedsetBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[59] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object weightedsetBody(WeightedSetOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 126: {
                this.jj_consume_token(126);
                field.setCreateIfNonExistent(true);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                field.setRemoveIfZero(true);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void rankType(FieldOperationContainer field) throws ParseException {
        String indexName = null;
        this.jj_consume_token(27);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        this.jj_consume_token(118);
        String typeName = this.identifier();
        RankTypeOperation op = new RankTypeOperation();
        op.setType(RankType.fromString(typeName));
        op.setIndexName(indexName);
        field.addOperation(op);
    }

    public final Object attribute(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        this.jj_consume_token(57);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        AttributeOperation op = new AttributeOperation(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.attributeSetting(field, op, name);
                break;
            }
            case 5: 
            case 116: {
                this.lbrace();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 58: 
                        case 84: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 108: {
                            break;
                        }
                        default: {
                            this.jj_la1[64] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.attributeSetting(field, op, name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[65] = this.jj_gen;
                                continue block13;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[66] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object sorting(FieldOperationContainer field, String name) throws ParseException {
        SortingOperation op = new SortingOperation(name);
        this.jj_consume_token(58);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.sortingSetting(op, name);
                break;
            }
            case 5: 
            case 116: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 59: 
                        case 60: 
                        case 64: 
                        case 65: 
                        case 66: {
                            break;
                        }
                        default: {
                            this.jj_la1[67] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.sortingSetting(op, name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[68] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object sortingSetting(SortingOperation sorting, String attributeName) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                sorting.setAscending();
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                sorting.setDescending();
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        sorting.setFunction(Sorting.Function.UCA);
                        break block0;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        sorting.setFunction(Sorting.Function.RAW);
                        break block0;
                    }
                    case 63: {
                        this.jj_consume_token(63);
                        sorting.setFunction(Sorting.Function.LOWERCASE);
                        break block0;
                    }
                }
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 66: {
                this.jj_consume_token(66);
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        this.jj_consume_token(67);
                        sorting.setStrength(Sorting.Strength.PRIMARY);
                        break block0;
                    }
                    case 68: {
                        this.jj_consume_token(68);
                        sorting.setStrength(Sorting.Strength.SECONDARY);
                        break block0;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        sorting.setStrength(Sorting.Strength.TERTIARY);
                        break block0;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        sorting.setStrength(Sorting.Strength.QUATERNARY);
                        break block0;
                    }
                    case 71: {
                        this.jj_consume_token(71);
                        sorting.setStrength(Sorting.Strength.IDENTICAL);
                        break block0;
                    }
                }
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(118);
                String locale = this.identifier();
                sorting.setLocale(locale);
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object attributeSetting(FieldOperationContainer field, AttributeOperation attribute, String attributeName) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                attribute.setHuge(true);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                attribute.setFastSearch(true);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                attribute.setFastAccess(true);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                attribute.setEnableBitVectors(true);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                attribute.setEnableOnlyBitVector(true);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                this.deployLogger.log(Level.WARNING, field + ": 'attribute : no-prefetch' is deprecated and has no effect.");
                attribute.setPrefetch(false);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                this.deployLogger.log(Level.WARNING, field + ": 'attribute : prefetch' is deprecated and has no effect.");
                attribute.setPrefetch(true);
                break;
            }
            case 58: {
                this.sorting(field, attributeName);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                String aliasedName = attributeName;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 42: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 115: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 157: 
                    case 158: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 173: 
                    case 177: {
                        aliasedName = this.identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[73] = this.jj_gen;
                    }
                }
                this.jj_consume_token(118);
                String alias = this.identifier();
                attribute.setDoAlias(true);
                attribute.setAlias(alias);
                attribute.setAliasedName(aliasedName);
                break;
            }
            case 108: {
                this.attributeTensorType(attribute);
                break;
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object attributeTensorType(AttributeOperation attribute) throws ParseException {
        TensorType tensorType = this.tensorType("For attribute field '" + attribute.getName() + "'");
        attribute.setTensorType(tensorType);
        return null;
    }

    public final Object summaryInDocument(DocumentSummary document) throws ParseException {
        this.jj_consume_token(48);
        String name = this.identifier();
        this.jj_consume_token(29);
        DataType type = this.dataType();
        SummaryField summary = new SummaryField(name, type);
        summary.setVsmCommand(SummaryField.VsmCommand.FLATTENSPACE);
        SummaryInFieldLongOperation op = new SummaryInFieldLongOperation();
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 50: 
                case 51: 
                case 56: 
                case 74: 
                case 95: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                    break block6;
                }
            }
            this.summaryItem(op);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[76] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        if (op.destinationIterator().hasNext()) {
            throw new ParseException("Summaries defined in a document-summary section can not have a 'to' line.");
        }
        op.applyToSummary(summary);
        document.add(summary);
        return null;
    }

    public final Object summaryInField(FieldOperationContainer field) throws ParseException {
        SummaryInFieldOperation summary;
        this.jj_consume_token(48);
        if (this.jj_2_7(2)) {
            summary = this.summaryInFieldShort(field);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 157: 
                case 158: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: {
                    summary = this.summaryInFieldLong(field);
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        field.addOperation(summary);
        return null;
    }

    public final SummaryInFieldOperation summaryInFieldShort(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        SummaryInFieldShortOperation op = new SummaryInFieldShortOperation(name);
        this.jj_consume_token(118);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                op.setTransform(SummaryTransform.DYNAMICTEASER);
                op.addSource(name);
                break;
            }
            case 49: 
            case 50: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[79] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                op.setTransform(SummaryTransform.NONE);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return op;
    }

    public final SummaryInFieldOperation summaryInFieldLong(FieldOperationContainer field) throws ParseException {
        String name = field.getName();
        DataType type = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                name = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        type = this.dataType();
                        break block0;
                    }
                }
                this.jj_la1[81] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
            }
        }
        this.lbrace();
        SummaryInFieldLongOperation op = new SummaryInFieldLongOperation(name);
        op.setType(type);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 49: 
                case 50: 
                case 51: 
                case 56: 
                case 74: 
                case 95: 
                case 96: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block12;
                }
            }
            this.summaryItem(op);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[84] = this.jj_gen;
                        continue block12;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        return op;
    }

    public final Object summaryItem(SummaryInFieldLongOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 49: 
            case 50: 
            case 51: {
                this.summaryTransform(field);
                break;
            }
            case 74: {
                this.summaryBolding(field);
                break;
            }
            case 95: {
                this.summarySourceList(field);
                break;
            }
            case 96: {
                this.summaryDestinationList(field);
                break;
            }
            case 56: {
                this.summaryProperties(field);
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object summaryTransform(SummaryInFieldOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                field.setTransform(SummaryTransform.DYNAMICTEASER);
                break;
            }
            case 49: 
            case 50: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                field.setTransform(SummaryTransform.NONE);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void summaryBolding(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(74);
        this.jj_consume_token(118);
        boolean bold = this.bool();
        field.setBold(bold);
    }

    public final void summarySourceList(SummaryInFieldOperation field) throws ParseException {
        block6: while (true) {
            this.jj_consume_token(95);
            this.jj_consume_token(118);
            String str = this.identifier();
            field.addSource(str);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 120: {
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(120);
                str = this.identifier();
                field.addSource(str);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[89] = this.jj_gen;
    }

    public final void summaryDestinationList(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(96);
        this.jj_consume_token(118);
        String str = this.identifier();
        field.addDestination(str);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[90] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(120);
            str = this.identifier();
            field.addDestination(str);
        }
    }

    public final void summaryProperties(SummaryInFieldLongOperation field) throws ParseException {
        this.jj_consume_token(56);
        this.lbrace();
        block3: while (true) {
            this.summaryProperty(field);
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 157: 
                case 158: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[91] = this.jj_gen;
        this.jj_consume_token(117);
    }

    public final void summaryProperty(SummaryInFieldLongOperation field) throws ParseException {
        String value;
        String name = this.identifier();
        this.jj_consume_token(118);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                value = this.identifier();
                break;
            }
            case 168: {
                value = this.quotedString();
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addProperty(new SummaryField.Property(name, value));
    }

    public final void fieldStemming(FieldOperationContainer field) throws ParseException {
        StemmingOperation op = new StemmingOperation();
        this.jj_consume_token(72);
        this.jj_consume_token(118);
        String setting = this.identifier();
        op.setSetting(setting);
        field.addOperation(op);
    }

    public final void searchStemming(Search search) throws ParseException {
        this.jj_consume_token(72);
        this.jj_consume_token(118);
        String setting = this.identifier();
        search.setStemming(Stemming.get(setting));
    }

    public final void normalizing(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(73);
        this.jj_consume_token(118);
        String setting = this.identifier();
        field.addOperation(new NormalizingOperation(setting));
    }

    public final void bolding(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(74);
        this.jj_consume_token(118);
        boolean bold = this.bool();
        field.addOperation(new BoldingOperation(bold));
    }

    public final void body(SDField field) throws ParseException {
        this.jj_consume_token(75);
        this.deployLogger.log(Level.WARNING, field + ": 'header/body' is deprecated and has no effect unless using deprecated vds engine.");
        field.setHeader(false);
        field.setHeaderOrBodyDefined(true);
    }

    public final void header(SDField field) throws ParseException {
        this.jj_consume_token(76);
        this.deployLogger.log(Level.WARNING, field + ": 'header/body' is deprecated and has no effect unless using deprecated vds engine.");
        field.setHeader(true);
        field.setHeaderOrBodyDefined(true);
    }

    public final void queryCommand(FieldOperationContainer container) throws ParseException {
        QueryCommandOperation field = new QueryCommandOperation();
        this.jj_consume_token(83);
        this.jj_consume_token(118);
        String command = this.identifier();
        field.addQueryCommand(command);
        container.addOperation(field);
    }

    public final void alias(FieldOperationContainer container) throws ParseException {
        String aliasedName = null;
        this.jj_consume_token(84);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                aliasedName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        this.jj_consume_token(118);
        String alias = this.identifier();
        AliasOperation op = new AliasOperation(aliasedName, alias);
        container.addOperation(op);
    }

    public final Object match(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(85);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.matchType(field);
                break;
            }
            case 5: 
            case 116: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 88: 
                        case 91: {
                            break;
                        }
                        default: {
                            this.jj_la1[94] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.matchItem(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[95] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object matchItem(FieldOperationContainer field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 88: {
                this.matchType(field);
                break;
            }
            case 91: {
                this.exactTerminator(field);
                break;
            }
            case 36: {
                this.gramSize(field);
                break;
            }
            case 37: {
                this.matchSize(field);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object matchType(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                field.setMatchingType(Matching.Type.TEXT);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                field.setMatchingType(Matching.Type.TEXT);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                field.setMatchingType(Matching.Type.WORD);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                field.setMatchingType(Matching.Type.EXACT);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                field.setMatchingType(Matching.Type.GRAM);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                field.setMatchingAlgorithm(Matching.Algorithm.PREFIX);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                field.setMatchingAlgorithm(Matching.Algorithm.SUBSTRING);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                field.setMatchingAlgorithm(Matching.Algorithm.SUFFIX);
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        container.addOperation(field);
        return null;
    }

    public final void exactTerminator(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(91);
        this.jj_consume_token(118);
        String terminator = this.quotedString();
        field.setExactMatchTerminator(terminator);
        container.addOperation(field);
    }

    public final void gramSize(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(36);
        this.jj_consume_token(118);
        int gramSize = this.integer();
        field.setGramSize(gramSize);
        container.addOperation(field);
    }

    public final void matchSize(FieldOperationContainer container) throws ParseException {
        MatchOperation field = new MatchOperation();
        this.jj_consume_token(37);
        this.jj_consume_token(118);
        int matchSize = this.integer();
        field.setMaxLength(matchSize);
        container.addOperation(field);
    }

    public final Object rank(FieldOperationContainer field) throws ParseException {
        RankOperation op = new RankOperation();
        this.jj_consume_token(86);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.rankSetting(op);
                break;
            }
            case 5: 
            case 116: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 87: 
                        case 89: 
                        case 90: {
                            break;
                        }
                        default: {
                            this.jj_la1[99] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.rankSetting(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[100] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addOperation(op);
        return null;
    }

    public final Object rankSetting(RankOperation field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                field.setLiteral(true);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                field.setNormal(true);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                field.setFilter(true);
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void id(FieldOperationContainer field, SDDocumentType document) throws ParseException {
        IdOperation op = new IdOperation();
        this.jj_consume_token(94);
        this.jj_consume_token(118);
        int fieldId = this.integer();
        op.setDocument(document);
        op.setFieldId(fieldId);
        field.addOperation(op);
    }

    public final void indexingRewrite(FieldOperationContainer field) throws ParseException {
        this.jj_consume_token(92);
        this.jj_consume_token(118);
        this.jj_consume_token(77);
        field.addOperation(new IndexingRewriteOperation());
    }

    public final Object documentSummary(Search search) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                this.deployLogger.log(Level.WARNING, "Directive 'summary' is deprecated, use 'document-summary' instead.");
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifier();
        DocumentSummary summary = new DocumentSummary(name);
        search.addSummary(summary);
        this.lbrace();
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    break;
                }
                default: {
                    this.jj_la1[104] = this.jj_gen;
                    break block10;
                }
            }
            this.documentSummaryItem(summary);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[105] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        return null;
    }

    public final Object documentSummaryItem(DocumentSummary summary) throws ParseException {
        this.summaryInDocument(summary);
        return null;
    }

    public final Object index(Search search, FieldOperationContainer field) throws ParseException {
        IndexOperation op = new IndexOperation();
        String indexName = field != null ? field.getName() : null;
        this.jj_consume_token(30);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
            }
        }
        if (indexName == null) {
            throw new ParseException("Index statements outside fields must have an explicit name.");
        }
        op.setIndexName(indexName);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 118: {
                this.jj_consume_token(118);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            break;
                        }
                        default: {
                            this.jj_la1[107] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(120);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 116: {
                this.lbrace();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 31: 
                        case 38: 
                        case 72: 
                        case 84: 
                        case 138: 
                        case 139: 
                        case 140: 
                        case 141: {
                            break;
                        }
                        default: {
                            this.jj_la1[108] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[109] = this.jj_gen;
                                continue block17;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[110] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (field == null) {
            Index index = new Index(indexName);
            op.applyToIndex(index);
            search.addIndex(index);
        } else {
            field.addOperation(op);
        }
        return null;
    }

    public final Object indexBody(IndexOperation index) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                index.setPrefix(true);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                this.jj_consume_token(118);
                String str = this.identifier();
                index.addAlias(str);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                this.jj_consume_token(118);
                String str = this.identifier();
                index.setStemming(str);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                throw new ParseException("'index:rise' is no longer an option. Use 'indexing:attribute' instead. If it is a weighted set field you should also add 'attribute:fast-search'.This change will require refeeding.");
            }
            case 138: {
                this.jj_consume_token(138);
                this.jj_consume_token(118);
                int arity = this.integer();
                index.setArity(arity);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                this.jj_consume_token(118);
                long num = this.consumeLong();
                index.setLowerBound(num);
                break;
            }
            case 140: {
                this.jj_consume_token(140);
                this.jj_consume_token(118);
                long num = this.consumeLong();
                index.setUpperBound(num);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                this.jj_consume_token(118);
                double threshold = this.consumeFloat();
                index.setDensePostingListThreshold(threshold);
                break;
            }
            default: {
                this.jj_la1[111] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void rankingConstant(Search search) throws ParseException {
        this.jj_consume_token(41);
        String name = this.identifier();
        RankingConstant constant = new RankingConstant(name);
        this.lbrace();
        block6: while (true) {
            this.rankingConstantItem(constant);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[112] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 166: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[113] = this.jj_gen;
        this.jj_consume_token(117);
        search.addRankingConstant(constant);
    }

    public final Object rankingConstantItem(RankingConstant constant) throws ParseException {
        String fileName = null;
        TensorType type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 166: {
                this.jj_consume_token(166);
                this.jj_consume_token(118);
                fileName = this.filePath();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[114] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(5);
                }
                constant.setFileName(fileName);
                break;
            }
            case 29: {
                type = this.tensorTypeWithPrefix(this.rankingConstantErrorMessage(constant.getName()));
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[115] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(5);
                }
                constant.setType(type);
                break;
            }
            default: {
                this.jj_la1[116] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final String rankingConstantErrorMessage(String name) throws ParseException {
        return "For ranking constant ' " + name + "'";
    }

    public final String filePath() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 174: {
                this.jj_consume_token(174);
                break;
            }
            case 173: {
                this.jj_consume_token(173);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                break;
            }
            default: {
                this.jj_la1[117] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final void rankProfile(Search search) throws ParseException {
        this.jj_consume_token(42);
        String name = this.identifier();
        RankProfile profile = "default".equals(name) ? this.rankProfileRegistry.getRankProfile(search, "default") : new RankProfile(name, search, this.rankProfileRegistry);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                this.inheritsRankProfile(profile);
                break;
            }
            default: {
                this.jj_la1[118] = this.jj_gen;
            }
        }
        this.lbrace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 28: 
                case 43: 
                case 44: 
                case 86: 
                case 93: 
                case 128: 
                case 134: 
                case 135: 
                case 136: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 157: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 165: {
                    break;
                }
                default: {
                    this.jj_la1[119] = this.jj_gen;
                    break block9;
                }
            }
            this.rankProfileItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[120] = this.jj_gen;
                        continue block9;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        this.rankProfileRegistry.addRankProfile(profile);
    }

    public final Object rankProfileItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                this.fieldRankType(profile);
                break;
            }
            case 28: {
                this.fieldWeight(profile);
                break;
            }
            case 86: {
                this.fieldRankFilter(profile);
                break;
            }
            case 134: {
                this.firstPhase(profile);
                break;
            }
            case 128: {
                this.matchPhase(profile);
                break;
            }
            case 136: {
                this.macro(profile);
                break;
            }
            case 93: {
                this.ignoreRankFeatures(profile);
                break;
            }
            case 159: {
                this.numThreadsPerSearch(profile);
                break;
            }
            case 160: {
                this.minHitsPerThread(profile);
                break;
            }
            case 161: {
                this.numSearchPartitions(profile);
                break;
            }
            case 162: {
                this.termwiseLimit(profile);
                break;
            }
            case 144: 
            case 145: {
                this.rankFeatures(profile);
                break;
            }
            case 157: {
                this.rankProperties(profile);
                break;
            }
            case 135: {
                this.secondPhase(profile);
                break;
            }
            case 43: 
            case 44: {
                this.rankDegradation(profile);
                break;
            }
            case 165: {
                this.constants(profile);
                break;
            }
            case 142: 
            case 143: {
                this.summaryFeatures(profile);
                break;
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void inheritsRankProfile(RankProfile profile) throws ParseException {
        this.jj_consume_token(17);
        String str = this.identifier();
        profile.setInherited(str);
    }

    public final void macro(RankProfile profile) throws ParseException {
        boolean inline = false;
        this.jj_consume_token(136);
        inline = this.inline();
        String macro = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 180: {
                this.jj_consume_token(180);
                macro = macro + this.token.image;
                break;
            }
            default: {
                this.jj_la1[122] = this.jj_gen;
            }
        }
        this.jj_consume_token(181);
        profile.addMacro(macro, inline);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: {
                String param = this.identifier();
                profile.getMacros().get(macro).addParam(param);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 120: {
                            break;
                        }
                        default: {
                            this.jj_la1[123] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(120);
                    param = this.identifier();
                    profile.getMacros().get(macro).addParam(param);
                }
            }
            default: {
                this.jj_la1[124] = this.jj_gen;
            }
        }
        this.jj_consume_token(182);
        this.lbrace();
        String expr = this.expression();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[125] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(117);
        profile.getMacros().get(macro).setTextualExpression(expr);
    }

    public final boolean inline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 137: {
                this.jj_consume_token(137);
                return true;
            }
        }
        this.jj_la1[126] = this.jj_gen;
        return false;
    }

    public final void matchPhase(RankProfile profile) throws ParseException {
        RankProfile.MatchPhaseSettings settings = new RankProfile.MatchPhaseSettings();
        this.jj_consume_token(128);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 57: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: {
                    break;
                }
                default: {
                    this.jj_la1[127] = this.jj_gen;
                    break block6;
                }
            }
            this.matchPhaseItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[128] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        settings.checkValid();
        profile.setMatchPhaseSettings(settings);
    }

    public final void matchPhaseItem(RankProfile.MatchPhaseSettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(118);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 9: {
                this.diversity(settings);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        this.jj_consume_token(59);
                        settings.setAscending(true);
                        break block0;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        settings.setAscending(false);
                        break block0;
                    }
                }
                this.jj_la1[129] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 133: {
                this.jj_consume_token(133);
                this.jj_consume_token(118);
                int num = this.integer();
                settings.setMaxHits(num);
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                this.jj_consume_token(118);
                double coverage = this.consumeFloat();
                settings.setMaxFilterCoverage(coverage);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                this.jj_consume_token(118);
                double multiplier = this.consumeFloat();
                settings.setEvaluationPoint(multiplier);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                this.jj_consume_token(118);
                double multiplier = this.consumeFloat();
                settings.setPrePostFilterTippingPoint(multiplier);
                break;
            }
            default: {
                this.jj_la1[130] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void diversity(RankProfile.MatchPhaseSettings profile) throws ParseException {
        RankProfile.DiversitySettings settings = new RankProfile.DiversitySettings();
        this.jj_consume_token(9);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 12: 
                case 57: {
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    break block6;
                }
            }
            this.diversityItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[132] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        profile.setDiversity(settings);
    }

    public final void diversityItem(RankProfile.DiversitySettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(118);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                this.jj_consume_token(118);
                int num = this.integer();
                settings.setMinGroups(num);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                this.jj_consume_token(118);
                double multiplier = this.consumeFloat();
                settings.setCutoffFactor(multiplier);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(118);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.strict);
                        break block0;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.loose);
                        break block0;
                    }
                }
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[134] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void firstPhase(RankProfile profile) throws ParseException {
        this.jj_consume_token(134);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: 
                case 147: 
                case 163: 
                case 164: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block6;
                }
            }
            this.firstPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[136] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
    }

    public final Object firstPhaseItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: 
            case 147: {
                String expression = this.expression();
                profile.setFirstPhaseRankingString(expression);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                this.jj_consume_token(118);
                int rerankCount = this.integer();
                profile.setKeepRankCount(rerankCount);
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                this.jj_consume_token(118);
                double dropLimit = this.consumeFloat();
                profile.setRankScoreDropLimit(dropLimit);
                break;
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void secondPhase(RankProfile profile) throws ParseException {
        this.jj_consume_token(135);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 146: 
                case 147: 
                case 158: {
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    break block6;
                }
            }
            this.secondPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[139] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
    }

    public final Object secondPhaseItem(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: 
            case 147: {
                String expression = this.expression();
                profile.setSecondPhaseRankingString(expression);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                this.jj_consume_token(118);
                int rerankCount = this.integer();
                profile.setRerankCount(rerankCount);
                break;
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object summaryFeatures(RankProfile profile) throws ParseException {
        String features;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 142: {
                this.jj_consume_token(142);
                features = this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                features = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
                break;
            }
            default: {
                this.jj_la1[141] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        profile.addSummaryFeatures(this.getFeatureList(features));
        return null;
    }

    public final Object rankFeatures(RankProfile profile) throws ParseException {
        String features;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 144: {
                this.jj_consume_token(144);
                features = this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                features = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
                break;
            }
            default: {
                this.jj_la1[142] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        profile.addRankFeatures(this.getFeatureList(features));
        return null;
    }

    public final void ignoreRankFeatures(RankProfile profile) throws ParseException {
        this.jj_consume_token(93);
        profile.setIgnoreDefaultRankFeatures(true);
    }

    public final void numThreadsPerSearch(RankProfile profile) throws ParseException {
        this.jj_consume_token(159);
        this.jj_consume_token(118);
        int num = this.integer();
        profile.setNumThreadsPerSearch(num);
    }

    public final void minHitsPerThread(RankProfile profile) throws ParseException {
        this.jj_consume_token(160);
        this.jj_consume_token(118);
        int num = this.integer();
        profile.setMinHitsPerThread(num);
    }

    public final void numSearchPartitions(RankProfile profile) throws ParseException {
        this.jj_consume_token(161);
        this.jj_consume_token(118);
        int num = this.integer();
        profile.setNumSearchPartitions(num);
    }

    public final void termwiseLimit(RankProfile profile) throws ParseException {
        this.jj_consume_token(162);
        this.jj_consume_token(118);
        double num = this.consumeFloat();
        profile.setTermwiseLimit(num);
    }

    public final void rankProperties(RankProfile profile) throws ParseException {
        this.jj_consume_token(157);
        this.lbrace();
        while (this.jj_2_8(Integer.MAX_VALUE)) {
            this.rankProperty(profile);
            block7: while (true) {
                this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[143] = this.jj_gen;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 111: 
            case 112: 
            case 113: 
            case 115: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 127: 
            case 128: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 157: 
            case 158: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 177: 
            case 181: 
            case 182: {
                this.rankProperty(profile);
                break;
            }
            default: {
                this.jj_la1[144] = this.jj_gen;
            }
        }
        this.jj_consume_token(117);
    }

    public final void rankProperty(RankProfile profile) throws ParseException {
        String key = this.rankPropertyItem();
        this.jj_consume_token(118);
        String val = this.rankPropertyItem();
        profile.addRankProperty(key, val);
    }

    public final String rankPropertyItem() throws ParseException {
        String ret = "";
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 157: 
                case 158: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: {
                    String image = this.identifier();
                    ret = ret + image;
                    break;
                }
                case 168: {
                    String image = this.quotedString();
                    ret = ret + image;
                    break;
                }
                case 119: 
                case 120: 
                case 181: 
                case 182: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 181: {
                            this.jj_consume_token(181);
                            break;
                        }
                        case 182: {
                            this.jj_consume_token(182);
                            break;
                        }
                        case 119: {
                            this.jj_consume_token(119);
                            break;
                        }
                        case 120: {
                            this.jj_consume_token(120);
                            break;
                        }
                        default: {
                            this.jj_la1[145] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    ret = ret + this.token.image;
                    break;
                }
                default: {
                    this.jj_la1[146] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 157: 
                case 158: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: 
                case 181: 
                case 182: {
                    continue block14;
                }
            }
            break;
        }
        this.jj_la1[147] = this.jj_gen;
        return ret;
    }

    public final void fieldWeight(RankProfile profile) throws ParseException {
        this.jj_consume_token(28);
        String name = this.identifier();
        this.jj_consume_token(118);
        Integer num = this.integer();
        profile.addRankSetting(name, RankProfile.RankSetting.Type.WEIGHT, num);
    }

    public final void fieldRankType(RankProfile profile) throws ParseException {
        this.jj_consume_token(27);
        String name = this.identifier();
        this.jj_consume_token(118);
        String type = this.identifier();
        profile.addRankSetting(name, RankProfile.RankSetting.Type.RANKTYPE, (Object)RankType.fromString(type));
    }

    public final void fieldRankFilter(RankProfile profile) throws ParseException {
        this.jj_consume_token(86);
        String name = this.identifier();
        this.jj_consume_token(118);
        this.jj_consume_token(89);
        profile.addRankSetting(name, RankProfile.RankSetting.Type.PREFERBITVECTOR, new Boolean(true));
    }

    public final void rankDegradationBinSize() throws ParseException {
        this.jj_consume_token(45);
        this.jj_consume_token(118);
        double freq = this.consumeFloat();
        this.deployLogger.log(Level.WARNING, "Specifying 'doc-frequency' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final void rankDegradationBinLow() throws ParseException {
        this.jj_consume_token(46);
        this.jj_consume_token(118);
        int n = this.integer();
        this.deployLogger.log(Level.WARNING, "Specifying 'min-fullrank-docs' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final void rankDegradationPosbinSize() throws ParseException {
        this.jj_consume_token(47);
        this.jj_consume_token(118);
        double avgOcc = this.consumeFloat();
        this.deployLogger.log(Level.WARNING, "Specifying 'occurrences-per-doc' in 'rank-degradation' is deprecated and has no effect.");
    }

    public final Object rankDegradationItem() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.rankDegradationBinSize();
                break;
            }
            case 46: {
                this.rankDegradationBinLow();
                break;
            }
            case 47: {
                this.rankDegradationPosbinSize();
                break;
            }
            default: {
                this.jj_la1[148] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final Object rankDegradation(RankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                this.jj_consume_token(118);
                double freq = this.consumeFloat();
                this.deployLogger.log(Level.WARNING, "Specifying 'rank-degradation-frequency' in 'rank-profile' is deprecated and has no effect.");
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                this.lbrace();
                block10: while (true) {
                    this.rankDegradationItem();
                    block11: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[149] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 45: 
                        case 46: 
                        case 47: {
                            continue block10;
                        }
                    }
                    break;
                }
                this.jj_la1[150] = this.jj_gen;
                this.jj_consume_token(117);
                break;
            }
            default: {
                this.jj_la1[151] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return null;
    }

    public final void constants(RankProfile profile) throws ParseException {
        this.jj_consume_token(165);
        this.jj_consume_token(116);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[152] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 38: 
                case 39: 
                case 40: 
                case 42: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 126: 
                case 127: 
                case 128: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 157: 
                case 158: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 177: {
                    break;
                }
                default: {
                    this.jj_la1[153] = this.jj_gen;
                    break block14;
                }
            }
            String name = this.identifier();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 118: {
                    this.constantValue(profile, name);
                    break;
                }
                case 116: {
                    this.constantTensor(profile, name);
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[155] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
    }

    public final void constantValue(RankProfile profile, String name) throws ParseException {
        this.jj_consume_token(118);
        String value = this.identifier();
        profile.addConstant(name, Value.parse((String)value));
    }

    public final void constantTensor(RankProfile profile, String name) throws ParseException {
        String tensorString = "";
        TensorType tensorType = null;
        this.jj_consume_token(116);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[156] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: 
                case 109: 
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[157] = this.jj_gen;
                    break block14;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 109: 
                case 110: {
                    tensorString = this.tensorValue();
                    break;
                }
                case 29: {
                    tensorType = this.tensorTypeWithPrefix(this.constantTensorErrorMessage(profile.getName(), name));
                    break;
                }
                default: {
                    this.jj_la1[158] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(117);
        if (tensorType != null) {
            profile.addConstantTensor(name, new TensorValue(Tensor.from((TensorType)tensorType, (String)tensorString)));
        } else {
            profile.addConstantTensor(name, new TensorValue(Tensor.from((String)tensorString)));
        }
    }

    public final String constantTensorErrorMessage(String rankProfileName, String constantTensorName) throws ParseException {
        return "For constant tensor '" + constantTensorName + "' in rank profile '" + rankProfileName + "'";
    }

    public final String tensorValue() throws ParseException {
        String tensor;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                tensor = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                tensor = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return tensor;
    }

    public final TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(118);
        TensorType type = this.tensorType(errorMessage);
        return type;
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(108);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void importField(Search search) throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(18);
        String fieldRefSpec = this.identifier();
        this.jj_consume_token(23);
        String aliasFieldName = this.identifier();
        this.lbrace();
        this.jj_consume_token(117);
        if (StringUtils.countMatches((String)fieldRefSpec, (String)".") != 1) {
            throw new IllegalArgumentException("Illegal field reference spec '" + fieldRefSpec + "': Does not include a single '.'");
        }
        int indexOfDot = fieldRefSpec.indexOf(46);
        String documentReferenceFieldName = fieldRefSpec.substring(0, indexOfDot);
        String foreignFieldName = fieldRefSpec.substring(indexOfDot + 1);
        search.temporaryImportedFields().get().add(new TemporaryImportedField(aliasFieldName, documentReferenceFieldName, foreignFieldName));
    }

    public final String expression() throws ParseException {
        String exp;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 146: {
                this.jj_consume_token(146);
                exp = this.token.image.substring(this.token.image.indexOf(":") + 1);
                break;
            }
            case 147: {
                this.jj_consume_token(147);
                exp = this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
                break;
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return exp;
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 138: {
                this.jj_consume_token(138);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 141: {
                this.jj_consume_token(141);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 166: {
                this.jj_consume_token(166);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 134: {
                this.jj_consume_token(134);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 172: {
                this.jj_consume_token(172);
                break;
            }
            case 139: {
                this.jj_consume_token(139);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 136: {
                this.jj_consume_token(136);
                break;
            }
            case 123: {
                this.jj_consume_token(123);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 157: {
                this.jj_consume_token(157);
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 135: {
                this.jj_consume_token(135);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            case 173: {
                this.jj_consume_token(173);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 140: {
                this.jj_consume_token(140);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 177: {
                this.jj_consume_token(177);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 122: {
                this.jj_consume_token(122);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 137: {
                this.jj_consume_token(137);
                break;
            }
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String string() throws ParseException {
        this.jj_consume_token(173);
        return this.token.image;
    }

    public final String quotedString() throws ParseException {
        this.jj_consume_token(168);
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    public final Boolean bool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: 
            case 80: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 78: {
                        this.jj_consume_token(78);
                        break;
                    }
                    case 80: {
                        this.jj_consume_token(80);
                        break;
                    }
                    default: {
                        this.jj_la1[163] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return true;
            }
            case 79: 
            case 81: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 79: {
                        this.jj_consume_token(79);
                        break;
                    }
                    case 81: {
                        this.jj_consume_token(81);
                        break;
                    }
                    default: {
                        this.jj_la1[164] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return false;
            }
        }
        this.jj_la1[165] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int integer() throws ParseException {
        this.jj_consume_token(171);
        return Integer.parseInt(this.token.image);
    }

    public final long consumeLong() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 171: {
                this.jj_consume_token(171);
                return Long.parseLong(this.token.image);
            }
            case 172: {
                this.jj_consume_token(172);
                return Long.parseLong(this.token.image.substring(0, this.token.image.length() - 1));
            }
        }
        this.jj_la1[166] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double consumeFloat() throws ParseException {
        this.jj_consume_token(170);
        return Double.valueOf(this.token.image);
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[167] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(116);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(49)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(50)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_94() {
        return this.jj_scan_token(51);
    }

    private boolean jj_3R_93() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_91() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_93()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(118)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_95()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(84)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(98)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(6)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(138)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(121)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(23)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(59)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(57)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(75)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(74)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(111)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(112)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(113)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(169)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(126)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(141)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(60)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(97)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(15)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(26)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(170)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(51)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(101)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(102)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(88)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(91)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(81)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(104)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(18)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(19)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(20)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(166)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(89)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(134)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(49)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(64)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(35)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(76)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(105)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(94)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(71)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(167)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(93)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(22)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(30)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(24)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(92)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(17)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(87)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(65)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(63)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(85)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(32)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(100)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(77)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(107)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(90)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(73)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(79)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(78)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(99)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(106)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(38)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(56)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(70)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(83)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(42)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(27)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(62)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(31)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(8)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(58)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(52)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(53)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(54)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(55)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(50)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(72)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(66)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(16)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(39)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(40)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(48)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(25)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(82)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(69)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(33)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(96)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(80)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(29)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(61)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(28)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(34)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_7() {
        return this.jj_3R_91();
    }

    private boolean jj_3R_101() {
        return this.jj_scan_token(168);
    }

    private boolean jj_3R_100() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(181)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(182)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(119)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(120)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_8() {
        if (this.jj_3R_92()) {
            return true;
        }
        if (this.jj_scan_token(118)) {
            return true;
        }
        if (this.jj_3R_92()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_99() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_98()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_99()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_100()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_98() {
        return this.jj_3R_97();
    }

    private boolean jj_3R_92() {
        Token xsp;
        if (this.jj_3R_96()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(124);
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(108);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(175);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(123)) {
            return true;
        }
        return this.jj_scan_token(175);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(122)) {
            return true;
        }
        return this.jj_scan_token(175);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(121)) {
            return true;
        }
        return this.jj_scan_token(175);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 33025, 1146454080, 32, 32, 1146454080, 32768, 32, -2129472, 32, 32, 131072, 32, 327744, 32, 32, 32, 131072, 32, 327744, 32, 327744, 32, 0, 32, 0, 0x20000000, 32, 0x20000000, 0, 1528823808, 32, 32, 524288, 0, -2129472, 524288, 32, 131072, 32, 131072, 262144, 32, 262144, 32, 0, -2129472, 32, 0, 0, 32, 0x3200000, 32, 1528823808, 0x3200000, 0, -2129472, 0, 0, 32, 32, 0, -2129472, -2129472, 0, 32, 32, 0, 32, 32, 0, 0, 0, -2129472, 0, 0, 32, -2129440, -2129472, 0, 0, 0x20000000, -2129472, 0, 32, 0, 0, 0, 0, 0, 0, -2129472, -2129472, -2129472, 0, 32, 32, 0, 0, 0, 32, 32, 0, 0x4000000, 0, 32, -2129472, 0, Integer.MIN_VALUE, 32, 32, Integer.MIN_VALUE, 32, 0x20000000, 32, 32, 0x20000000, 0, 131072, 0x18000000, 32, 0x18000000, 0, 0, -2129472, 32, 0, 512, 32, 0, 512, 7168, 32, 24576, 7168, 0, 32, 0, 0, 32, 0, 0, 0, 32, -2129472, 0, -2129472, -2129472, 0, 32, 0, 0, 32, -2129472, 0, 32, 32, 0x20000000, 0x20000000, 32, 0, 0, -2129472, 0, 0, 0, 0, 32, 32};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 67072, 0, 0, 67072, 0, 0, -64049, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x6010000, 0, 0, 0, 0, -64049, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64049, 0, 0, 0, 0, 65536, 0, 0x6010000, 65536, 0, -64049, 0, 0, 0, 0, 0, -64049, -64049, 0x4000000, 0, 0, 0x18000000, 0, 0, -536870912, 0, 0x18000000, -64049, 0x4000000, 0x10E0000, 0, -64049, -64049, 393216, 917504, 0, -64049, 0x10E0000, 0, 0x10E0000, 393216, 917504, 0, 0, 0, -64049, -64049, -64049, 511, 0, 0, 511, 463, 0, 0, 0, 0, 65536, 65536, 0, -64049, 0, 64, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 6144, 0, 6144, 0, 0, -64049, 0, 0, 0x2000000, 0, 0x18000000, 0x2000000, 0x2000000, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -64049, 0, -64049, -64049, 57344, 0, 57344, 6144, 0, -64049, 0, 0, 0, 0, 0, 0, 0, 0, -64049, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 256, 0, 0, 256, 0, 0, -1, 0, 0, 0, 0, 6144, 0, 0, 0, 0, 0, 6144, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 1350049536, 0, 0, 0x280000, 0, -1, 0x280000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0x40000000, 0x200000, 0, 0x280000, 0, 1350049536, 0x280000, 0, -1, 0, 0, 0, 0, 0, -1, -1, 0x100000, 0, 0, 7, 0, 0, 0, 248, 7, -1, 0x100000, -2147482624, 0, -1, -1, 0, 0, 0, -1, -2147482624, 0, -2147482624, 0, 0, 0, Integer.MIN_VALUE, 0, -1, -1, -1, 0x9000000, 0, 0, 0x9000000, 0x1000000, 0x6800000, 0, 0, 0x6800000, 0, 0, 0, -1, 0, 0x100100, 0, 0, 0x100100, 0, 0, 0, 0, 0, 0, 0, 0x20400000, 0, 0x20400000, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 81920, 163840, 245760, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 524288, 0, 0, 524288, 0, 0, -569667585, 0, 0, 0, 0, 32768, 0, 0, 0, 0, 0, 32768, 0, 32768, 0, 32768, 0, 32768, 196608, 0, 196608, 0x1000000, 0x4000000, 0, 0, 0, 0x1000000, -569667585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -569667585, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x400000, -569667585, 0x1000000, -1073741824, 0, 0x500000, -1073741824, -569667585, -569667585, 8160, 0, 0x500000, 0, 0, 0x500000, 0, 0, 0, -569667585, 8160, 1, 0, -568619009, -569667585, 0, 0, 0, -569667585, 1, 0, 1, 0, 0, 0x1000000, 0, 0x1000000, -569667585, -569667585, -569667585, 0, 0, 0x500000, 0, 0, 0, 0, 0x500000, 0, 0, 0, 0, -569667585, 0x1000000, 0, 0, 0x500000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, -569667585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -544501761, 0x1800000, -544501761, -544501761, 0, 0, 0, 0, 0, -569667585, 0x500000, 0, 0, 24576, 24576, 0, 24576, 0, -569667585, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 1610629113, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 1610629113, 1610629113, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 1610629113, 1610629113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1610629113, 0, 15360, 0, 0, 15360, 0, 0, 0, 0, 0, 0, 0, -1610366527, 0, -1610366527, 0, 0, 1610629113, 0, 512, 62, 0, 0, 62, 0, 0, 0, 0, 786432, 0, 786432, 0x400C0000, 0, 0x400C0000, 49152, 196608, 0, 1610629113, 0, 1610629113, 1610629113, 0, 0, 0, 0, 0, 1610629113, 0, 0, 0, 0, 0, 0, 0, 786432, 1610629113, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147448, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 0, 0, 147192, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 147192, 147192, 0, 0, 0, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 147192, 147448, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 0, 0, 0, 64, 0, 0, 64, 24704, 0, 39, 0, 39, 0x100000, 0, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 24, 0, 0, 0, 0, 0, 0, 6438904, 0x600000, 6438904, 6438904, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 0, 0, 0, 0, 0, 147192, 0, 0, 0, 6144, 0, 0};
    }

    public SDParser(CharStream stream) {
        int i;
        this.token_source = new SDParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 169; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 169; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SDParser(SDParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 169; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SDParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 169; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[183];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 169; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) == 0) continue;
                la1tokens[160 + j] = true;
            }
        }
        for (i = 0; i < 183; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SDParser.jj_la1_init_0();
        SDParser.jj_la1_init_1();
        SDParser.jj_la1_init_2();
        SDParser.jj_la1_init_3();
        SDParser.jj_la1_init_4();
        SDParser.jj_la1_init_5();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

