/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.document;

import com.yahoo.language.process.StemMode;
import java.util.logging.Logger;

public enum Stemming {
    NONE("none"),
    ALL("all"),
    SHORTEST("shortest"),
    BEST("best"),
    MULTIPLE("multiple");

    private static Logger log;
    private final String name;

    public static Stemming get(String stemmingName) {
        try {
            Stemming stemming = Stemming.valueOf(stemmingName.toUpperCase());
            if (stemming.equals((Object)ALL)) {
                log.warning("note: stemming ALL is the same as stemming mode SHORTEST");
                stemming = SHORTEST;
            }
            return stemming;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + stemmingName + "' is not a valid stemming setting");
        }
    }

    private Stemming(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "stemming " + this.name;
    }

    public StemMode toStemMode() {
        switch (this) {
            case SHORTEST: {
                return StemMode.SHORTEST;
            }
            case MULTIPLE: {
                return StemMode.ALL;
            }
            case BEST: {
                return StemMode.BEST;
            }
            case NONE: {
                return StemMode.NONE;
            }
            case ALL: {
                return StemMode.SHORTEST;
            }
        }
        throw new IllegalStateException("Inconvertible stem mode " + (Object)((Object)this));
    }

    static {
        log = Logger.getLogger(Stemming.class.getName());
    }
}

