/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.tensor.TensorType;
import java.util.Objects;

public class RankingConstant {
    private final String name;
    private TensorType tensorType = null;
    private String fileName = null;
    private String fileRef = "";

    public RankingConstant(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        Objects.requireNonNull(fileName, "Filename cannot be null");
        this.fileName = fileName;
    }

    public void setFileReference(String fileRef) {
        this.fileRef = fileRef;
    }

    public void setType(TensorType tensorType) {
        this.tensorType = tensorType;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileReference() {
        return this.fileRef;
    }

    public TensorType getTensorType() {
        return this.tensorType;
    }

    public String getType() {
        return this.tensorType.toString();
    }

    public void validate() {
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new IllegalArgumentException("Ranking constants must have a file.");
        }
        if (this.tensorType == null) {
            throw new IllegalArgumentException("Ranking constant '" + this.name + "' must have a type.");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("constant '").append(this.name).append("' from file '").append(this.fileName).append("' with ref '").append(this.fileRef).append("' of type '").append(this.tensorType).append("'");
        return b.toString();
    }
}

