/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.config.search.core.FdispatchrcConfig;
import com.yahoo.vespa.config.search.core.PartitionsConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.content.SearchCoverage;
import com.yahoo.vespa.model.search.DispatchGroup;
import com.yahoo.vespa.model.search.NodeSpec;
import com.yahoo.vespa.model.search.SearchInterface;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;

@RestartConfigs(value={FdispatchrcConfig.class, PartitionsConfig.class})
public class Dispatch
extends AbstractService
implements SearchInterface,
FdispatchrcConfig.Producer,
PartitionsConfig.Producer {
    private static final String TLD_NAME = "tld";
    private static final String DISPATCH_NAME = "dispatch";
    private static final long serialVersionUID = 1L;
    private final DispatchGroup dispatchGroup;
    private final NodeSpec nodeSpec;
    private final int dispatchLevel;
    private final boolean preferLocalRow;
    private final boolean isTopLevel;

    private Dispatch(DispatchGroup dispatchGroup, AbstractConfigProducer parent, String subConfigId, NodeSpec nodeSpec, int dispatchLevel, boolean preferLocalRow, boolean isTopLevel) {
        super(parent, subConfigId);
        this.dispatchGroup = dispatchGroup;
        this.nodeSpec = nodeSpec;
        this.dispatchLevel = dispatchLevel;
        this.preferLocalRow = preferLocalRow;
        this.isTopLevel = isTopLevel;
        this.portsMeta.on(0).tag("rpc").tag("admin");
        this.portsMeta.on(1).tag("fs4");
        this.portsMeta.on(2).tag("http").tag("json").tag("health").tag("state");
        this.setProp("clustertype", "search").setProp("clustername", dispatchGroup.getClusterName()).setProp("index", nodeSpec.groupIndex());
        this.monitorService();
    }

    public static Dispatch createTld(DispatchGroup dispatchGroup, AbstractConfigProducer parent, int rowId) {
        return Dispatch.createTld(dispatchGroup, parent, rowId, false);
    }

    public static Dispatch createTld(DispatchGroup dispatchGroup, AbstractConfigProducer parent, int rowId, boolean preferLocalRow) {
        String subConfigId = "tld." + rowId;
        return new Dispatch(dispatchGroup, parent, subConfigId, new NodeSpec(rowId, 0), 0, preferLocalRow, true);
    }

    public static Dispatch createTldWithContainerIdInName(DispatchGroup dispatchGroup, AbstractConfigProducer parent, String containerName, int containerIndex) {
        String subConfigId = containerName + "." + containerIndex + "." + TLD_NAME + "." + containerIndex;
        return new Dispatch(dispatchGroup, parent, subConfigId, new NodeSpec(containerIndex, 0), 0, false, true);
    }

    public static Dispatch createDispatchWithStableConfigId(DispatchGroup dispatchGroup, AbstractConfigProducer parent, NodeSpec nodeSpec, int distributionKey, int dispatchLevel) {
        String subConfigId = "dispatch." + distributionKey;
        return new Dispatch(dispatchGroup, parent, subConfigId, nodeSpec, dispatchLevel, false, false);
    }

    @Override
    public String getServiceType() {
        return "topleveldispatch";
    }

    @Override
    public String getStartupCommand() {
        return "exec sbin/vespa-dispatch -c $VESPA_CONFIG_ID";
    }

    public int getFrtPort() {
        return this.getRelativePort(0);
    }

    public int getDispatchPort() {
        return this.getRelativePort(1);
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(2);
    }

    public int getMaxThreads() {
        return 1000;
    }

    public String getHostname() {
        return this.getHost().getHostName();
    }

    @Override
    public NodeSpec getNodeSpec() {
        return this.nodeSpec;
    }

    @Override
    public String getDispatcherConnectSpec() {
        return "tcp/" + this.getHost().getHostName() + ":" + this.getDispatchPort();
    }

    public DispatchGroup getDispatchGroup() {
        return this.dispatchGroup;
    }

    public void getConfig(FdispatchrcConfig.Builder builder) {
        builder.ptport(this.getDispatchPort()).frtport(this.getFrtPort()).healthport(this.getHealthPort()).maxthreads(this.getMaxThreads());
        if (!this.isTopLevel) {
            builder.partition(this.getNodeSpec().partitionId());
            builder.dispatchlevel(this.dispatchLevel);
        }
    }

    public void getConfig(PartitionsConfig.Builder builder) {
        SearchCoverage coverage;
        int rowbits = this.dispatchGroup.getRowBits();
        PartitionsConfig.Dataset.Builder datasetBuilder = new PartitionsConfig.Dataset.Builder().id(0).refcost(1).rowbits(rowbits).numparts(this.dispatchGroup.getNumPartitions()).mpp(this.dispatchGroup.getMinNodesPerColumn());
        if (this.dispatchGroup.useFixedRowInDispatch()) {
            datasetBuilder.querydistribution(PartitionsConfig.Dataset.Querydistribution.Enum.FIXEDROW);
            datasetBuilder.maxnodesdownperfixedrow(this.dispatchGroup.getMaxNodesDownPerFixedRow());
        }
        if ((coverage = this.dispatchGroup.getSearchCoverage()) != null) {
            if (coverage.getMinimum() != null) {
                datasetBuilder.minimal_searchcoverage(coverage.getMinimum() * 100.0);
            }
            if (coverage.getMinWaitAfterCoverageFactor() != null) {
                datasetBuilder.higher_coverage_minsearchwait(coverage.getMinWaitAfterCoverageFactor().doubleValue());
            }
            if (coverage.getMaxWaitAfterCoverageFactor() != null) {
                datasetBuilder.higher_coverage_maxsearchwait(coverage.getMaxWaitAfterCoverageFactor().doubleValue());
            }
        }
        Tuning tuning = this.dispatchGroup.getTuning();
        boolean useLocalNode = false;
        if (tuning != null && tuning.dispatch != null) {
            useLocalNode = tuning.dispatch.useLocalNode;
        }
        ArrayList<PartitionsConfig.Dataset.Engine.Builder> allEngines = new ArrayList<PartitionsConfig.Dataset.Engine.Builder>();
        for (SearchInterface searchNode : this.dispatchGroup.getSearchersIterable()) {
            PartitionsConfig.Dataset.Engine.Builder engineBuilder = new PartitionsConfig.Dataset.Engine.Builder().name_and_port(searchNode.getDispatcherConnectSpec()).rowid(searchNode.getNodeSpec().groupIndex()).partid(searchNode.getNodeSpec().partitionId());
            allEngines.add(engineBuilder);
            if (this.preferLocalRow) {
                if (this.getHostname().equals(searchNode.getHostName())) {
                    engineBuilder.refcost(1);
                } else {
                    engineBuilder.refcost(Integer.MAX_VALUE);
                }
            }
            if (useLocalNode && !this.getHostname().equals(searchNode.getHostName())) continue;
            if (useLocalNode) {
                engineBuilder.rowid(0);
            }
            datasetBuilder.engine.add(engineBuilder);
        }
        if (datasetBuilder.engine.isEmpty() && useLocalNode) {
            for (PartitionsConfig.Dataset.Engine.Builder engineBuilder : allEngines) {
                datasetBuilder.engine.add(engineBuilder);
            }
        }
        builder.dataset.add(datasetBuilder);
        if (tuning != null) {
            tuning.getConfig(builder);
            this.scaleMaxHitsPerPartitions(builder, tuning);
        }
    }

    private int getNumLeafNodesInGroup() {
        int numSearchers = 0;
        for (SearchInterface search : this.dispatchGroup.getSearchersIterable()) {
            if (search instanceof Dispatch) {
                numSearchers += ((Dispatch)search).getNumLeafNodesInGroup();
                continue;
            }
            ++numSearchers;
        }
        if (numSearchers > 0) {
            return numSearchers / this.dispatchGroup.getNumPartitions();
        }
        return 0;
    }

    private void scaleMaxHitsPerPartitions(PartitionsConfig.Builder builder, Tuning tuning) {
        if (tuning == null || tuning.dispatch == null || tuning.dispatch.maxHitsPerPartition == null) {
            return;
        }
        int numLeafNodes = this.getNumLeafNodesInGroup();
        for (PartitionsConfig.Dataset.Builder dataset : builder.dataset) {
            dataset.maxhitspernode(tuning.dispatch.maxHitsPerPartition * numLeafNodes);
        }
    }

    @Override
    public int getPortCount() {
        return 3;
    }
}

