/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.IndexSchema;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRefeedAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AttributeChangeValidator {
    private final AttributeFields currentFields;
    private final IndexSchema currentIndexSchema;
    private final NewDocumentType currentDocType;
    private final AttributeFields nextFields;
    private final IndexSchema nextIndexSchema;
    private final NewDocumentType nextDocType;

    public AttributeChangeValidator(AttributeFields currentFields, IndexSchema currentIndexSchema, NewDocumentType currentDocType, AttributeFields nextFields, IndexSchema nextIndexSchema, NewDocumentType nextDocType) {
        this.currentFields = currentFields;
        this.currentIndexSchema = currentIndexSchema;
        this.currentDocType = currentDocType;
        this.nextFields = nextFields;
        this.nextIndexSchema = nextIndexSchema;
        this.nextDocType = nextDocType;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAddAttributeAspect());
        result.addAll(this.validateRemoveAttributeAspect());
        result.addAll(this.validateAttributeSettings());
        result.addAll(this.validateTensorTypes(overrides, now));
        return result;
    }

    private List<VespaConfigChangeAction> validateAddAttributeAspect() {
        return this.nextFields.attributes().stream().map(attr -> attr.getName()).filter(attrName -> !this.currentFields.containsAttribute((String)attrName) && this.currentDocType.containsField((String)attrName)).map(attrName -> new VespaRestartAction(new ChangeMessageBuilder((String)attrName).addChange("add attribute aspect").build())).collect(Collectors.toList());
    }

    private List<VespaConfigChangeAction> validateRemoveAttributeAspect() {
        return this.currentFields.attributes().stream().map(attr -> attr.getName()).filter(attrName -> !this.nextFields.containsAttribute((String)attrName) && this.nextDocType.containsField((String)attrName) && !this.isIndexField((String)attrName)).map(attrName -> new VespaRestartAction(new ChangeMessageBuilder((String)attrName).addChange("remove attribute aspect").build())).collect(Collectors.toList());
    }

    private boolean isIndexField(String fieldName) {
        return this.currentIndexSchema.containsField(fieldName) && this.nextIndexSchema.containsField(fieldName);
    }

    private List<VespaConfigChangeAction> validateAttributeSettings() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Attribute nextAttr : this.nextFields.attributes()) {
            Attribute currAttr = this.currentFields.getAttribute(nextAttr.getName());
            if (currAttr == null) continue;
            AttributeChangeValidator.validateAttributeSetting(currAttr, nextAttr, Attribute::isFastSearch, "fast-search", result);
            AttributeChangeValidator.validateAttributeSetting(currAttr, nextAttr, Attribute::isFastAccess, "fast-access", result);
            AttributeChangeValidator.validateAttributeSetting(currAttr, nextAttr, Attribute::isHuge, "huge", result);
            AttributeChangeValidator.validateAttributeSetting(currAttr, nextAttr, Attribute::densePostingListThreshold, "dense-posting-list-threshold", result);
        }
        return result;
    }

    private List<VespaConfigChangeAction> validateTensorTypes(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Attribute nextAttr : this.nextFields.attributes()) {
            Attribute currentAttr = this.currentFields.getAttribute(nextAttr.getName());
            if (currentAttr == null || !currentAttr.tensorType().isPresent() || !nextAttr.tensorType().isPresent() || nextAttr.tensorType().get().equals((Object)currentAttr.tensorType().get())) continue;
            result.add(AttributeChangeValidator.createTensorTypeChangedRefeedAction(currentAttr, nextAttr, overrides, now));
        }
        return result;
    }

    private static VespaRefeedAction createTensorTypeChangedRefeedAction(Attribute currentAttr, Attribute nextAttr, ValidationOverrides overrides, Instant now) {
        return VespaRefeedAction.of("tensor-type-change", overrides, new ChangeMessageBuilder(nextAttr.getName()).addChange("tensor type", currentAttr.tensorType().get().toString(), nextAttr.tensorType().get().toString()).build(), now);
    }

    private static void validateAttributeSetting(Attribute currentAttr, Attribute nextAttr, Predicate<Attribute> predicate, String setting, List<VespaConfigChangeAction> result) {
        boolean nextValue = predicate.test(nextAttr);
        if (predicate.test(currentAttr) != nextValue) {
            String change = nextValue ? "add" : "remove";
            result.add(new VespaRestartAction(new ChangeMessageBuilder(nextAttr.getName()).addChange(change + " attribute '" + setting + "'").build()));
        }
    }

    private static <T> void validateAttributeSetting(Attribute currentAttr, Attribute nextAttr, Function<Attribute, T> settingValueProvider, String setting, List<VespaConfigChangeAction> result) {
        T nextValue;
        T currentValue = settingValueProvider.apply(currentAttr);
        if (!Objects.equals(currentValue, nextValue = settingValueProvider.apply(nextAttr))) {
            String message = String.format("change property '%s' from '%s' to '%s'", setting, currentValue, nextValue);
            result.add(new VespaRestartAction(new ChangeMessageBuilder(nextAttr.getName()).addChange(message).build()));
        }
    }
}

