/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.indexinglanguage.expressions.SetLanguageExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;

public class SetLanguage
extends Processor {
    public SetLanguage(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        ArrayList<String> textFieldsWithoutLanguage = new ArrayList<String>();
        for (SDField field : this.search.allConcreteFields()) {
            if (this.fieldMustComeAfterLanguageSettingField(field)) {
                textFieldsWithoutLanguage.add(field.getName());
            }
            if (!field.containsExpression(SetLanguageExpression.class) || textFieldsWithoutLanguage.isEmpty()) continue;
            StringBuffer fieldString = new StringBuffer();
            for (String fieldName : textFieldsWithoutLanguage) {
                fieldString.append(fieldName).append(" ");
            }
            this.warn(this.search, field, "Field '" + field.getName() + "' sets the language for this document, and should be defined as the first field in the searchdefinition. If you have both header and body fields, this field should be header, if you require it to affect subsequent header fields and/or any body fields. Preceding text fields that will not have their language set: " + fieldString.toString() + " (This warning is omitted for any subsequent fields that also do set_language.)");
            return;
        }
    }

    private boolean fieldMustComeAfterLanguageSettingField(SDField field) {
        return !field.containsExpression(SetLanguageExpression.class) && field.getDataType() == DataType.STRING;
    }
}

