/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.searchdefinition.Index;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.BooleanIndexDefinition;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.searchdefinition.processing.TypedTransformProvider;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.OptimizePredicateExpression;
import com.yahoo.vespa.indexinglanguage.expressions.OutputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetValueExpression;
import com.yahoo.vespa.indexinglanguage.expressions.SetVarExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.ArrayList;

public class PredicateProcessor
extends Processor {
    public PredicateProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            if (field.getDataType() == DataType.PREDICATE) {
                if (field.doesIndexing()) {
                    this.fail(this.search, field, "Use 'attribute' instead of 'index'. This will require a refeed if you have upgraded.");
                }
                if (!field.doesAttributing()) continue;
                Attribute attribute = field.getAttributes().get(field.getName());
                for (Index index : field.getIndices().values()) {
                    double threshold;
                    BooleanIndexDefinition booleanDefinition = index.getBooleanIndexDefiniton();
                    if (booleanDefinition == null || !booleanDefinition.hasArity()) {
                        this.fail(this.search, field, "Missing arity value in predicate field.");
                    }
                    if (booleanDefinition.getArity() < 2) {
                        this.fail(this.search, field, "Invalid arity value in predicate field, must be greater than 1.");
                    }
                    if ((threshold = booleanDefinition.getDensePostingListThreshold()) <= 0.0 || threshold > 1.0) {
                        this.fail(this.search, field, "Invalid dense-posting-list-threshold value in predicate field. Value must be in range (0..1].");
                    }
                    attribute.setArity(booleanDefinition.getArity());
                    attribute.setLowerBound(booleanDefinition.getLowerBound());
                    attribute.setUpperBound(booleanDefinition.getUpperBound());
                    attribute.setDensePostingListThreshold(threshold);
                    this.addPredicateOptimizationIlScript(field, booleanDefinition);
                }
                DocumentSummary summary = this.search.getSummary("attributeprefetch");
                if (summary != null) {
                    summary.remove(attribute.getName());
                }
                for (SummaryField summaryField : this.search.getSummaryFields(field).values()) {
                    summaryField.setTransform(SummaryTransform.NONE);
                }
                continue;
            }
            if (field.getDataType().getPrimitiveType() == DataType.PREDICATE) {
                this.fail(this.search, field, "Collections of predicates are not allowed.");
                continue;
            }
            if (field.getDataType() == DataType.RAW && field.doesIndexing()) {
                this.fail(this.search, field, "Indexing of RAW fields are not supported. If you are using RAW fields for boolean search, use predicate data type instead.");
                continue;
            }
            for (Index index : field.getIndices().values()) {
                if (index.getBooleanIndexDefiniton() == null) continue;
                BooleanIndexDefinition booleanIndexDefinition = index.getBooleanIndexDefiniton();
                if (booleanIndexDefinition.hasArity()) {
                    this.fail(this.search, field, "Arity parameter is used only for predicate type fields.");
                    continue;
                }
                if (booleanIndexDefinition.hasLowerBound() || booleanIndexDefinition.hasUpperBound()) {
                    this.fail(this.search, field, "Parameters lower-bound and upper-bound are used only for predicate type fields.");
                    continue;
                }
                if (!booleanIndexDefinition.hasDensePostingListThreshold()) continue;
                this.fail(this.search, field, "Parameter dense-posting-list-threshold is used only for predicate type fields.");
            }
        }
    }

    private void addPredicateOptimizationIlScript(SDField field, BooleanIndexDefinition booleanIndexDefiniton) {
        ScriptExpression script = field.getIndexingScript();
        if (script == null) {
            return;
        }
        script = new StatementExpression(new Expression[]{this.makeSetPredicateVariablesScript(booleanIndexDefiniton), script});
        PredicateOutputTransformer converter = new PredicateOutputTransformer(this.search);
        field.setIndexingScript(new ScriptExpression(new StatementExpression[]{(StatementExpression)converter.convert((Expression)script)}));
    }

    private Expression makeSetPredicateVariablesScript(BooleanIndexDefinition options) {
        ArrayList<Object> expressions = new ArrayList<Object>();
        expressions.add(new SetValueExpression((FieldValue)new IntegerFieldValue(options.getArity())));
        expressions.add(new SetVarExpression("arity"));
        if (options.hasLowerBound()) {
            expressions.add(new SetValueExpression((FieldValue)new LongFieldValue(options.getLowerBound())));
            expressions.add(new SetVarExpression("lower_bound"));
        }
        if (options.hasUpperBound()) {
            expressions.add(new SetValueExpression((FieldValue)new LongFieldValue(options.getUpperBound())));
            expressions.add(new SetVarExpression("upper_bound"));
        }
        return new StatementExpression(expressions);
    }

    private static class PredicateOutputTransformer
    extends TypedTransformProvider {
        PredicateOutputTransformer(Search search) {
            super(OptimizePredicateExpression.class, search);
        }

        @Override
        protected boolean requiresTransform(Expression exp, DataType fieldType) {
            return exp instanceof OutputExpression && fieldType == DataType.PREDICATE;
        }

        @Override
        protected Expression newTransform(DataType fieldType) {
            return new OptimizePredicateExpression();
        }
    }
}

