/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.fieldoperation;

import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.fieldoperation.FieldOperation;
import java.util.Iterator;

public class WeightedSetOperation
implements FieldOperation {
    private Boolean createIfNonExistent;
    private Boolean removeIfZero;

    public Boolean getCreateIfNonExistent() {
        return this.createIfNonExistent;
    }

    public void setCreateIfNonExistent(Boolean createIfNonExistent) {
        this.createIfNonExistent = createIfNonExistent;
    }

    public Boolean getRemoveIfZero() {
        return this.removeIfZero;
    }

    public void setRemoveIfZero(Boolean removeIfZero) {
        this.removeIfZero = removeIfZero;
    }

    @Override
    public void apply(SDField field) {
        WeightedSetDataType ctype = (WeightedSetDataType)field.getDataType();
        if (this.createIfNonExistent != null) {
            field.setDataType((DataType)DataType.getWeightedSet((DataType)ctype.getNestedType(), (boolean)this.createIfNonExistent, (boolean)ctype.removeIfZero()));
        }
        ctype = (WeightedSetDataType)field.getDataType();
        if (this.removeIfZero != null) {
            field.setDataType((DataType)DataType.getWeightedSet((DataType)ctype.getNestedType(), (boolean)ctype.createIfNonExistent(), (boolean)this.removeIfZero));
        }
        ctype = (WeightedSetDataType)field.getDataType();
        Iterator<Attribute> iterator = field.getAttributes().values().iterator();
        while (iterator.hasNext()) {
            Attribute o;
            Attribute attribute = o = iterator.next();
            attribute.setRemoveIfZero(ctype.removeIfZero());
            attribute.setCreateIfNonExistent(ctype.createIfNonExistent());
        }
    }

    @Override
    public int compareTo(FieldOperation other) {
        return -1;
    }

    public String toString() {
        return "WeightedSetOperation{createIfNonExistent=" + this.createIfNonExistent + ", removeIfZero=" + this.removeIfZero + '}';
    }
}

