/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.vespa.config.search.ImportedFieldsConfig;
import java.util.Optional;

public class ImportedFields
extends Derived
implements ImportedFieldsConfig.Producer {
    private Optional<com.yahoo.searchdefinition.document.ImportedFields> importedFields = Optional.empty();

    public ImportedFields(Search search) {
        this.derive(search);
    }

    @Override
    protected void derive(Search search) {
        this.importedFields = search.importedFields();
    }

    @Override
    protected String getDerivedName() {
        return "imported-fields";
    }

    public void getConfig(ImportedFieldsConfig.Builder builder) {
        if (this.importedFields.isPresent()) {
            this.importedFields.get().fields().forEach((name, field) -> ImportedFields.considerField(builder, field));
        }
    }

    private static void considerField(ImportedFieldsConfig.Builder builder, ImportedField field) {
        if (field.targetField().doesAttributing()) {
            builder.attribute.add(ImportedFields.createAttributeBuilder(field));
        }
    }

    private static ImportedFieldsConfig.Attribute.Builder createAttributeBuilder(ImportedField field) {
        ImportedFieldsConfig.Attribute.Builder result = new ImportedFieldsConfig.Attribute.Builder();
        result.name(field.fieldName());
        result.referencefield(field.reference().referenceField().getName());
        result.targetfield(field.targetField().getName());
        return result;
    }
}

