/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class ContainerEndpoint {
    private final String clusterId;
    private final ApplicationClusterEndpoint.Scope scope;
    private final List<String> names;
    private final OptionalInt weight;
    private final ApplicationClusterEndpoint.RoutingMethod routingMethod;
    private final ApplicationClusterEndpoint.AuthMethod authMethod;

    public ContainerEndpoint(String clusterId, ApplicationClusterEndpoint.Scope scope, List<String> names) {
        this(clusterId, scope, names, OptionalInt.empty());
    }

    public ContainerEndpoint(String clusterId, ApplicationClusterEndpoint.Scope scope, List<String> names, OptionalInt weight) {
        this(clusterId, scope, names, weight, ApplicationClusterEndpoint.RoutingMethod.sharedLayer4);
    }

    public ContainerEndpoint(String clusterId, ApplicationClusterEndpoint.Scope scope, List<String> names, OptionalInt weight, ApplicationClusterEndpoint.RoutingMethod routingMethod) {
        this(clusterId, scope, names, weight, routingMethod, ApplicationClusterEndpoint.AuthMethod.mtls);
    }

    public ContainerEndpoint(String clusterId, ApplicationClusterEndpoint.Scope scope, List<String> names, OptionalInt weight, ApplicationClusterEndpoint.RoutingMethod routingMethod, ApplicationClusterEndpoint.AuthMethod authMethod) {
        this.clusterId = Objects.requireNonNull(clusterId);
        this.scope = Objects.requireNonNull(scope);
        this.names = List.copyOf((Collection)Objects.requireNonNull(names));
        this.weight = Objects.requireNonNull(weight);
        this.routingMethod = Objects.requireNonNull(routingMethod);
        this.authMethod = Objects.requireNonNull(authMethod);
    }

    public String clusterId() {
        return this.clusterId;
    }

    public List<String> names() {
        return this.names;
    }

    public ApplicationClusterEndpoint.Scope scope() {
        return this.scope;
    }

    public OptionalInt weight() {
        return this.weight;
    }

    public ApplicationClusterEndpoint.RoutingMethod routingMethod() {
        return this.routingMethod;
    }

    public ApplicationClusterEndpoint.AuthMethod authMethod() {
        return this.authMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerEndpoint that = (ContainerEndpoint)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals((Object)this.scope, (Object)that.scope) && Objects.equals(this.names, that.names) && Objects.equals(this.weight, that.weight) && Objects.equals((Object)this.routingMethod, (Object)that.routingMethod) && Objects.equals((Object)this.authMethod, (Object)that.authMethod);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clusterId, this.names, this.scope, this.weight, this.routingMethod, this.authMethod});
    }

    public String toString() {
        return String.format("container endpoint %s -> %s [scope=%s, weight=%s, routingMethod=%s, authMethod=%s]", new Object[]{this.clusterId, this.names, this.scope, this.weight, this.routingMethod, this.authMethod});
    }
}

