/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.text.Utf8;
import java.io.IOException;

public class ApplicationMetaData {
    private final String deployedFromDir;
    private final long deployTimestamp;
    private final boolean internalRedeploy;
    private final ApplicationId applicationId;
    private final String checksum;
    private final long generation;
    private final long previousActiveGeneration;

    public ApplicationMetaData(String deployedFromDir, Long deployTimestamp, boolean internalRedeploy, ApplicationId applicationId, String checksum, Long generation, long previousActiveGeneration) {
        this("unknown", deployedFromDir, deployTimestamp, internalRedeploy, applicationId, checksum, generation, previousActiveGeneration);
    }

    @Deprecated
    public ApplicationMetaData(String ignored, String deployedFromDir, Long deployTimestamp, boolean internalRedeploy, ApplicationId applicationId, String checksum, Long generation, long previousActiveGeneration) {
        this.deployedFromDir = deployedFromDir;
        this.deployTimestamp = deployTimestamp;
        this.internalRedeploy = internalRedeploy;
        this.applicationId = applicationId;
        this.checksum = checksum;
        this.generation = generation;
        this.previousActiveGeneration = previousActiveGeneration;
    }

    @Deprecated
    public String getDeployedByUser() {
        return "unknown";
    }

    public String getDeployPath() {
        return this.deployedFromDir;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Long getDeployTimestamp() {
        return this.deployTimestamp;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public long getPreviousActiveGeneration() {
        return this.previousActiveGeneration;
    }

    public String toString() {
        return this.deployedFromDir + ", " + this.deployTimestamp + ", " + this.generation + ", " + this.checksum + ", " + this.previousActiveGeneration;
    }

    public static ApplicationMetaData fromJsonString(String jsonString) {
        try {
            Slime data = SlimeUtils.jsonToSlime((String)jsonString);
            Cursor root = data.get();
            Inspector deploy = root.field("deploy");
            Inspector app = root.field("application");
            return new ApplicationMetaData(deploy.field("from").asString(), deploy.field("timestamp").asLong(), ApplicationMetaData.booleanField("internalRedeploy", false, deploy), ApplicationId.fromSerializedForm((String)app.field("id").asString()), app.field("checksum").asString(), app.field("generation").asLong(), app.field("previousActiveGeneration").asLong());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing json metadata", e);
        }
    }

    public Slime getSlime() {
        Slime slime = new Slime();
        Cursor meta = slime.setObject();
        Cursor deploy = meta.setObject("deploy");
        deploy.setString("from", this.deployedFromDir);
        deploy.setLong("timestamp", this.deployTimestamp);
        deploy.setBool("internalRedeploy", this.internalRedeploy);
        Cursor app = meta.setObject("application");
        app.setString("id", this.applicationId.serializedForm());
        app.setString("checksum", this.checksum);
        app.setLong("generation", this.generation);
        app.setLong("previousActiveGeneration", this.previousActiveGeneration);
        return slime;
    }

    private static boolean booleanField(String fieldName, boolean defaultValue, Inspector object) {
        Inspector value = object.field(fieldName);
        if (!value.valid()) {
            return defaultValue;
        }
        return value.asBool();
    }

    public String asJsonString() {
        return Utf8.toString((byte[])this.asJsonBytes());
    }

    public byte[] asJsonBytes() {
        try {
            return SlimeUtils.toJsonBytes((Slime)this.getSlime());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode metadata", e);
        }
    }
}

