/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.provision.RegionName;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Bcp {
    private static final Bcp empty = new Bcp(List.of(), Optional.empty());
    private final Optional<Duration> defaultDeadline;
    private final List<Group> groups;

    public Bcp(List<Group> groups, Optional<Duration> defaultDeadline) {
        this.totalMembershipSumsToOne(groups);
        this.defaultDeadline = defaultDeadline;
        this.groups = List.copyOf(groups);
    }

    public Optional<Duration> defaultDeadline() {
        return this.defaultDeadline;
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Bcp withGroups(List<Group> groups) {
        return new Bcp(groups, this.defaultDeadline);
    }

    public Set<RegionName> regions() {
        return this.groups.stream().flatMap(group -> group.members().stream()).map(member -> member.region()).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.groups.isEmpty() && this.defaultDeadline.isEmpty();
    }

    public Bcp orElse(Bcp other) {
        return this.isEmpty() ? other : this;
    }

    private void totalMembershipSumsToOne(List<Group> groups) {
        HashMap<RegionName, Double> totalMembership = new HashMap<RegionName, Double>();
        for (Group group : groups) {
            for (RegionMember member : group.members()) {
                totalMembership.compute(member.region(), (__, fraction) -> fraction == null ? member.fraction() : fraction + member.fraction());
            }
        }
        for (Map.Entry entry : totalMembership.entrySet()) {
            if ((Double)entry.getValue() == 1.0) continue;
            throw new IllegalArgumentException("Illegal BCP spec: All regions must have total membership fractions summing to 1.0, but " + entry.getKey() + " sums to " + entry.getValue());
        }
    }

    public static Bcp empty() {
        return empty;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "empty BCP";
        }
        return "BCP of " + (this.groups.isEmpty() ? "no groups" : this.groups) + (String)(this.defaultDeadline.isEmpty() ? "" : ", deadline: " + this.defaultDeadline.get());
    }

    public static class Group {
        private final List<RegionMember> members;
        private final Set<RegionName> memberRegions;
        private final Duration deadline;

        public Group(List<RegionMember> members, Duration deadline) {
            this.members = List.copyOf(members);
            this.memberRegions = members.stream().map(member -> member.region()).collect(Collectors.toSet());
            this.deadline = deadline;
        }

        public List<RegionMember> members() {
            return this.members;
        }

        public Set<RegionName> memberRegions() {
            return this.memberRegions;
        }

        public Duration deadline() {
            return this.deadline;
        }

        public String toString() {
            return "BCP group of " + this.members;
        }
    }

    public record RegionMember(RegionName region, double fraction) {
        public RegionMember {
            if (fraction < 0.0 || fraction > 1.0) {
                throw new IllegalArgumentException("Fraction must be a number between 0.0 and 1.0, but got " + fraction);
            }
        }
    }
}

