/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.provision.RegionName;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Bcp {
    private static final Bcp empty = new Bcp(List.of());
    private final List<Group> groups;

    public Bcp(List<Group> groups) {
        this.totalMembershipSumsToOne(groups);
        this.groups = List.copyOf(groups);
    }

    public List<Group> groups() {
        return this.groups;
    }

    public Set<RegionName> regions() {
        return this.groups.stream().flatMap(group -> group.members().stream()).map(member -> member.region()).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public Bcp orElse(Bcp other) {
        return this.isEmpty() ? other : this;
    }

    private void totalMembershipSumsToOne(List<Group> groups) {
        HashMap<RegionName, Double> totalMembership = new HashMap<RegionName, Double>();
        for (Group group : groups) {
            for (RegionMember member : group.members()) {
                totalMembership.compute(member.region(), (__, fraction) -> fraction == null ? member.fraction() : fraction + member.fraction());
            }
        }
        for (Map.Entry entry : totalMembership.entrySet()) {
            if ((Double)entry.getValue() == 1.0) continue;
            throw new IllegalArgumentException("Illegal BCP spec: All regions must have total membership fractions summing to 1.0, but " + entry.getKey() + " sums to " + entry.getValue());
        }
    }

    public static Bcp empty() {
        return empty;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "empty BCP";
        }
        return "BCP of " + this.groups;
    }

    public static class Group {
        private final List<RegionMember> members;
        private final List<Endpoint> endpoints;
        private final Duration deadline;

        public Group(List<RegionMember> members, Duration deadline) {
            this(members, List.of(), deadline);
        }

        public Group(List<RegionMember> members, List<Endpoint> endpoints, Duration deadline) {
            this.members = List.copyOf(members);
            this.endpoints = endpoints;
            this.deadline = deadline;
        }

        public List<RegionMember> members() {
            return this.members;
        }

        List<Endpoint> endpoints() {
            return this.endpoints;
        }

        public Duration deadline() {
            return this.deadline;
        }

        public String toString() {
            return "BCP group of " + this.members;
        }
    }

    public record RegionMember(RegionName region, double fraction) {
        public RegionMember {
            if (fraction < 0.0 || fraction > 1.0) {
                throw new IllegalArgumentException("Fraction must be a number between 0.0 and 1.0, but got " + fraction);
            }
        }
    }
}

