/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api.xml;

import com.yahoo.config.application.api.Bcp;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Tags;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.stream.Stream;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentSpecXmlReader {
    private static final String deploymentTag = "deployment";
    private static final String instanceTag = "instance";
    private static final String tagsTag = "tags";
    private static final String testTag = "test";
    private static final String stagingTag = "staging";
    private static final String devTag = "dev";
    private static final String perfTag = "perf";
    private static final String upgradeTag = "upgrade";
    private static final String blockChangeTag = "block-change";
    private static final String prodTag = "prod";
    private static final String regionTag = "region";
    private static final String delayTag = "delay";
    private static final String parallelTag = "parallel";
    private static final String stepsTag = "steps";
    private static final String endpointsTag = "endpoints";
    private static final String endpointTag = "endpoint";
    private static final String notificationsTag = "notifications";
    private static final String idAttribute = "id";
    private static final String athenzServiceAttribute = "athenz-service";
    private static final String athenzDomainAttribute = "athenz-domain";
    private static final String testerFlavorAttribute = "tester-flavor";
    private static final String majorVersionAttribute = "major-version";
    private static final String globalServiceIdAttribute = "global-service-id";
    private static final String cloudAccountAttribute = "cloud-account";
    private final boolean validate;
    private final Clock clock;
    private final List<DeploymentSpec.DeprecatedElement> deprecatedElements = new ArrayList<DeploymentSpec.DeprecatedElement>();

    public DeploymentSpecXmlReader(boolean validate, Clock clock) {
        this.validate = validate;
        this.clock = clock;
    }

    public DeploymentSpecXmlReader() {
        this(true);
    }

    public DeploymentSpecXmlReader(boolean validate) {
        this(validate, Clock.systemUTC());
    }

    public DeploymentSpec read(Reader reader) {
        try {
            return this.read(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public DeploymentSpec read(String xmlForm) {
        this.deprecatedElements.clear();
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        if (!root.getTagName().equals(deploymentTag)) {
            DeploymentSpecXmlReader.illegal("The root tag must be <deployment>");
        }
        if (DeploymentSpecXmlReader.isEmptySpec(root)) {
            return DeploymentSpec.empty;
        }
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        ArrayList<Endpoint> applicationEndpoints = new ArrayList<Endpoint>();
        if (!this.containsTag(instanceTag, root)) {
            steps.addAll(this.readInstanceContent("default", root, new HashMap<String, String>(), root));
        } else {
            if (XML.getChildren((Element)root).stream().anyMatch(child -> child.getTagName().equals(prodTag))) {
                DeploymentSpecXmlReader.illegal("A deployment spec cannot have both a <prod> tag and an <instance> tag under the root: Wrap the prod tags inside the appropriate instance");
            }
            for (Element child2 : XML.getChildren((Element)root)) {
                String tagName = child2.getTagName();
                if (tagName.equals(instanceTag)) {
                    steps.addAll(this.readInstanceContent(child2.getAttribute(idAttribute), child2, new HashMap<String, String>(), root));
                    continue;
                }
                steps.addAll(this.readNonInstanceSteps(child2, new HashMap<String, String>(), root));
            }
            this.readEndpoints(root, Optional.empty(), steps, applicationEndpoints, Map.of());
        }
        return new DeploymentSpec(steps, this.optionalIntegerAttribute(majorVersionAttribute, root), DeploymentSpecXmlReader.stringAttribute(athenzDomainAttribute, root).map(AthenzDomain::from), DeploymentSpecXmlReader.stringAttribute(athenzServiceAttribute, root).map(AthenzService::from), DeploymentSpecXmlReader.stringAttribute(cloudAccountAttribute, root).map(CloudAccount::from), applicationEndpoints, DeploymentSpecXmlReader.readBcp(root), xmlForm, this.deprecatedElements);
    }

    private List<DeploymentInstanceSpec> readInstanceContent(String instanceNameString, Element instanceElement, Map<String, String> prodAttributes, Element parentTag) {
        if (instanceNameString.isBlank()) {
            DeploymentSpecXmlReader.illegal("<instance> attribute 'id' must be specified, and not be blank");
        }
        if (XML.getChildren((Element)instanceElement).isEmpty() && (instanceElement.getAttributes().getLength() == 0 || instanceElement == parentTag)) {
            return List.of();
        }
        if (this.validate) {
            this.validateTagOrder(instanceElement);
        }
        DeploymentSpec.UpgradePolicy upgradePolicy = this.getWithFallback(instanceElement, parentTag, upgradeTag, "policy", this::readUpgradePolicy, DeploymentSpec.UpgradePolicy.defaultPolicy);
        DeploymentSpec.RevisionTarget revisionTarget = this.getWithFallback(instanceElement, parentTag, upgradeTag, "revision-target", this::readRevisionTarget, DeploymentSpec.RevisionTarget.latest);
        DeploymentSpec.RevisionChange revisionChange = this.getWithFallback(instanceElement, parentTag, upgradeTag, "revision-change", this::readRevisionChange, DeploymentSpec.RevisionChange.whenFailing);
        DeploymentSpec.UpgradeRollout upgradeRollout = this.getWithFallback(instanceElement, parentTag, upgradeTag, "rollout", this::readUpgradeRollout, DeploymentSpec.UpgradeRollout.separate);
        int minRisk = this.getWithFallback(instanceElement, parentTag, upgradeTag, "min-risk", Integer::parseInt, 0);
        int maxRisk = this.getWithFallback(instanceElement, parentTag, upgradeTag, "max-risk", Integer::parseInt, 0);
        int maxIdleHours = this.getWithFallback(instanceElement, parentTag, upgradeTag, "max-idle-hours", Integer::parseInt, 8);
        List<DeploymentSpec.ChangeBlocker> changeBlockers = this.readChangeBlockers(instanceElement, parentTag);
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(instanceElement, athenzServiceAttribute).map(AthenzService::from);
        Optional<CloudAccount> cloudAccount = DeploymentSpecXmlReader.mostSpecificAttribute(instanceElement, cloudAccountAttribute).map(CloudAccount::from);
        Notifications notifications = this.readNotifications(instanceElement, parentTag);
        Tags tags = XML.attribute((String)tagsTag, (Element)instanceElement).map(Tags::fromString).orElse(Tags.empty());
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        for (Element instanceChild : XML.getChildren((Element)instanceElement)) {
            steps.addAll(this.readNonInstanceSteps(instanceChild, prodAttributes, instanceChild));
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        LinkedHashMap<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> zoneEndpoints = new LinkedHashMap<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>>();
        this.readEndpoints(instanceElement, Optional.of(instanceNameString), steps, endpoints, zoneEndpoints);
        Instant now = this.clock.instant();
        return Arrays.stream(instanceNameString.split(",")).map(name -> name.trim()).map(name -> new DeploymentInstanceSpec(InstanceName.from((String)name), tags, steps, upgradePolicy, revisionTarget, revisionChange, upgradeRollout, minRisk, maxRisk, maxIdleHours, changeBlockers, Optional.ofNullable((String)prodAttributes.get(globalServiceIdAttribute)), athenzService, cloudAccount, notifications, endpoints, zoneEndpoints, DeploymentSpecXmlReader.readBcp(instanceElement), now)).toList();
    }

    private List<DeploymentSpec.Step> readSteps(Element stepTag, Map<String, String> prodAttributes, Element parentTag) {
        if (stepTag.getTagName().equals(instanceTag)) {
            return new ArrayList<DeploymentSpec.Step>(this.readInstanceContent(stepTag.getAttribute(idAttribute), stepTag, prodAttributes, parentTag));
        }
        return this.readNonInstanceSteps(stepTag, prodAttributes, parentTag);
    }

    private List<DeploymentSpec.Step> readNonInstanceSteps(Element stepTag, Map<String, String> prodAttributes, Element parentTag) {
        Optional<AthenzService> athenzService = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, athenzServiceAttribute).map(AthenzService::from);
        Optional<String> testerFlavor = DeploymentSpecXmlReader.mostSpecificAttribute(stepTag, testerFlavorAttribute);
        if (prodTag.equals(stepTag.getTagName())) {
            this.readGlobalServiceId(stepTag).ifPresent(id -> prodAttributes.put(globalServiceIdAttribute, (String)id));
        } else if (this.readGlobalServiceId(stepTag).isPresent()) {
            DeploymentSpecXmlReader.illegal("Attribute 'global-service-id' is only valid on 'prod' tag");
        }
        switch (stepTag.getTagName()) {
            case "test": {
                if (Stream.iterate(stepTag, Objects::nonNull, Node::getParentNode).anyMatch(node -> prodTag.equals(node.getNodeName()))) {
                    return List.of(new DeploymentSpec.DeclaredTest(RegionName.from((String)XML.getValue((Element)stepTag).trim())));
                }
                return List.of(new DeploymentSpec.DeclaredZone(Environment.from((String)stepTag.getTagName()), Optional.empty(), false, athenzService, testerFlavor, this.readCloudAccount(stepTag)));
            }
            case "dev": 
            case "perf": 
            case "staging": {
                return List.of(new DeploymentSpec.DeclaredZone(Environment.from((String)stepTag.getTagName()), Optional.empty(), false, athenzService, testerFlavor, this.readCloudAccount(stepTag)));
            }
            case "prod": {
                return XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readNonInstanceSteps((Element)child, prodAttributes, stepTag).stream()).toList();
            }
            case "delay": {
                return List.of(new DeploymentSpec.Delay(Duration.ofSeconds(this.longAttribute("hours", stepTag) * 60L * 60L + this.longAttribute("minutes", stepTag) * 60L + this.longAttribute("seconds", stepTag))));
            }
            case "parallel": {
                return List.of(new DeploymentSpec.ParallelSteps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, prodAttributes, parentTag).stream()).toList()));
            }
            case "steps": {
                return List.of(new DeploymentSpec.Steps(XML.getChildren((Element)stepTag).stream().flatMap(child -> this.readSteps((Element)child, prodAttributes, parentTag).stream()).toList()));
            }
            case "region": {
                return List.of(this.readDeclaredZone(Environment.prod, athenzService, testerFlavor, stepTag));
            }
        }
        return List.of();
    }

    private boolean containsTag(String childTagName, Element parent) {
        for (Element child : XML.getChildren((Element)parent)) {
            if (!child.getTagName().equals(childTagName) && !this.containsTag(childTagName, child)) continue;
            return true;
        }
        return false;
    }

    private Notifications readNotifications(Element parent, Element fallbackParent) {
        Element notificationsElement = XML.getChild((Element)parent, (String)notificationsTag);
        if (notificationsElement == null) {
            notificationsElement = XML.getChild((Element)fallbackParent, (String)notificationsTag);
        }
        if (notificationsElement == null) {
            return Notifications.none();
        }
        Notifications.When defaultWhen = DeploymentSpecXmlReader.stringAttribute("when", notificationsElement).map(Notifications.When::fromValue).orElse(Notifications.When.failingCommit);
        HashMap<Notifications.When, List<String>> emailAddresses = new HashMap<Notifications.When, List<String>>();
        HashMap<Notifications.When, List<Notifications.Role>> emailRoles = new HashMap<Notifications.When, List<Notifications.Role>>();
        for (Notifications.When when : Notifications.When.values()) {
            emailAddresses.put(when, new ArrayList());
            emailRoles.put(when, new ArrayList());
        }
        for (Element emailElement : XML.getChildren((Element)notificationsElement, (String)"email")) {
            Optional<String> addressAttribute = DeploymentSpecXmlReader.stringAttribute("address", emailElement);
            Optional<Notifications.Role> roleAttribute = DeploymentSpecXmlReader.stringAttribute("role", emailElement).map(Notifications.Role::fromValue);
            Notifications.When when = DeploymentSpecXmlReader.stringAttribute("when", emailElement).map(Notifications.When::fromValue).orElse(defaultWhen);
            if (addressAttribute.isPresent() == roleAttribute.isPresent()) {
                DeploymentSpecXmlReader.illegal("Exactly one of 'role' and 'address' must be present in 'email' elements.");
            }
            addressAttribute.ifPresent(address -> ((List)emailAddresses.get((Object)when)).add(address));
            roleAttribute.ifPresent(role -> ((List)emailRoles.get((Object)when)).add(role));
        }
        return Notifications.of(emailAddresses, emailRoles);
    }

    private void readEndpoints(Element parent, Optional<String> instance, List<DeploymentSpec.Step> steps, List<Endpoint> endpoints, Map<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> zoneEndpoints) {
        Element endpointsElement = XML.getChild((Element)parent, (String)endpointsTag);
        if (endpointsElement == null) {
            return;
        }
        Endpoint.Level level = instance.isEmpty() ? Endpoint.Level.application : Endpoint.Level.instance;
        LinkedHashMap endpointsById = new LinkedHashMap();
        LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>> endpointsByZone = new LinkedHashMap<String, Map<RegionName, List<ZoneEndpoint>>>();
        XML.getChildren((Element)endpointsElement, (String)endpointTag).stream().sorted(Comparator.comparingInt(endpoint -> DeploymentSpecXmlReader.getZoneEndpointType(endpoint, level).isPresent() ? 0 : 1)).forEach(endpointElement -> {
            String invalidChild;
            String containerId = DeploymentSpecXmlReader.requireStringAttribute("container-id", endpointElement);
            Optional<String> endpointId = DeploymentSpecXmlReader.stringAttribute(idAttribute, endpointElement);
            Optional<String> zoneEndpointType = DeploymentSpecXmlReader.getZoneEndpointType(endpointElement, level);
            String msgPrefix = (level == Endpoint.Level.application ? "Application-level" : "Instance-level") + " endpoint '" + endpointId.orElse("default") + "': ";
            if (zoneEndpointType.isPresent() && endpointId.isPresent()) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "cannot declare 'id' with type 'zone' or 'private'");
            }
            String string = invalidChild = level == Endpoint.Level.application ? regionTag : instanceTag;
            if (!XML.getChildren((Element)endpointElement, (String)invalidChild).isEmpty()) {
                DeploymentSpecXmlReader.illegal(msgPrefix + "invalid element '" + invalidChild + "'");
            }
            boolean enabled = XML.attribute((String)"enabled", (Element)endpointElement).map(value -> {
                if (zoneEndpointType.isEmpty() || !((String)zoneEndpointType.get()).equals("zone")) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "only endpoints of type 'zone' can specify 'enabled'");
                }
                return switch (value) {
                    case "true" -> true;
                    case "false" -> false;
                    default -> throw new IllegalArgumentException(msgPrefix + "invalid 'enabled' value; must be 'true' or 'false'");
                };
            }).orElse(true);
            ArrayList<ZoneEndpoint.AllowedUrn> allowedUrns = new ArrayList<ZoneEndpoint.AllowedUrn>();
            block18: for (Element allow : XML.getChildren((Element)endpointElement, (String)"allow")) {
                if (zoneEndpointType.isEmpty() || !zoneEndpointType.get().equals("private")) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "only endpoints of type 'private' can specify 'allow' children");
                }
                switch (DeploymentSpecXmlReader.requireStringAttribute("with", allow)) {
                    case "aws-private-link": {
                        allowedUrns.add(new ZoneEndpoint.AllowedUrn(ZoneEndpoint.AccessType.awsPrivateLink, DeploymentSpecXmlReader.requireStringAttribute("arn", allow)));
                        continue block18;
                    }
                    case "gcp-service-connect": {
                        allowedUrns.add(new ZoneEndpoint.AllowedUrn(ZoneEndpoint.AccessType.gcpServiceConnect, DeploymentSpecXmlReader.requireStringAttribute("project", allow)));
                        continue block18;
                    }
                }
                DeploymentSpecXmlReader.illegal("Private endpoint for container-id '" + containerId + "': invalid attribute 'with': '" + DeploymentSpecXmlReader.requireStringAttribute("with", allow) + "'");
            }
            ArrayList<Endpoint.Target> targets = new ArrayList<Endpoint.Target>();
            if (level == Endpoint.Level.application) {
                Optional<String> endpointRegion = DeploymentSpecXmlReader.stringAttribute(regionTag, endpointElement);
                int weightSum = 0;
                for (Element element : XML.getChildren((Element)endpointElement, (String)instanceTag)) {
                    int weight;
                    String instanceName = element.getTextContent();
                    if (instanceName == null || instanceName.isBlank()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'instance' element");
                    }
                    Optional<String> instanceRegion = DeploymentSpecXmlReader.stringAttribute(regionTag, element);
                    if (endpointRegion.isPresent() == instanceRegion.isPresent()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "'region' attribute must be declared on either <endpoint> or <instance> tag");
                    }
                    String weightFromAttribute = DeploymentSpecXmlReader.requireStringAttribute("weight", element);
                    try {
                        weight = Integer.parseInt(weightFromAttribute);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(msgPrefix + "invalid weight value '" + weightFromAttribute + "'");
                    }
                    weightSum += weight;
                    targets.add(new Endpoint.Target(RegionName.from((String)endpointRegion.orElseGet(instanceRegion::get)), InstanceName.from((String)instanceName), weight));
                }
                if (weightSum == 0) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "sum of all weights must be positive, got " + weightSum);
                }
            } else {
                if (DeploymentSpecXmlReader.stringAttribute(regionTag, endpointElement).isPresent()) {
                    DeploymentSpecXmlReader.illegal(msgPrefix + "invalid 'region' attribute");
                }
                LinkedHashSet<RegionName> regions = new LinkedHashSet<RegionName>();
                for (Element regionElement : XML.getChildren((Element)endpointElement, (String)regionTag)) {
                    String string2 = regionElement.getTextContent();
                    if (string2 == null || string2.isBlank()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "empty 'region' element");
                    }
                    if (zoneEndpointType.isEmpty()) {
                        if (Stream.of(RegionName.from((String)string2), null).map(endpointsByZone.getOrDefault(containerId, new HashMap())::get).flatMap(maybeEndpoints -> maybeEndpoints == null ? Stream.empty() : maybeEndpoints.stream()).anyMatch(endpoint -> !endpoint.isPublicEndpoint())) {
                            DeploymentSpecXmlReader.illegal(msgPrefix + "targets zone endpoint in '" + string2 + "' with 'enabled' set to 'false'");
                        }
                    }
                    if (regions.add(RegionName.from((String)string2))) continue;
                    DeploymentSpecXmlReader.illegal(msgPrefix + "duplicate 'region' element: '" + string2 + "'");
                }
                if (zoneEndpointType.isPresent()) {
                    void var17_28;
                    if (regions.isEmpty()) {
                        regions.add(null);
                    }
                    String string3 = zoneEndpointType.get();
                    int n = -1;
                    switch (string3.hashCode()) {
                        case 3744684: {
                            if (!string3.equals("zone")) break;
                            boolean bl = false;
                            break;
                        }
                        case -314497661: {
                            if (!string3.equals("private")) break;
                            boolean bl = true;
                        }
                    }
                    ZoneEndpoint endpoint2 = switch (var17_28) {
                        case 0 -> new ZoneEndpoint(enabled, false, List.of());
                        case 1 -> new ZoneEndpoint(true, true, allowedUrns);
                        default -> throw new IllegalArgumentException("unsupported zone endpoint type '" + zoneEndpointType.get() + "'");
                    };
                    for (RegionName regionName : regions) {
                        endpointsByZone.computeIfAbsent(containerId, __ -> new LinkedHashMap()).computeIfAbsent(regionName, __ -> new ArrayList()).add(endpoint2);
                    }
                } else {
                    if (regions.isEmpty()) {
                        List declared = steps.stream().filter(step -> step.concerns(Environment.prod)).flatMap(step -> step.zones().stream()).flatMap(zone -> zone.region().stream()).toList();
                        if (declared.isEmpty()) {
                            DeploymentSpecXmlReader.illegal(msgPrefix + "no declared regions to target");
                        }
                        declared.stream().filter(region -> Stream.of(region, null).map(endpointsByZone.getOrDefault(containerId, new HashMap())::get).flatMap(maybeEndpoints -> maybeEndpoints == null ? Stream.empty() : maybeEndpoints.stream()).allMatch(ZoneEndpoint::isPublicEndpoint)).forEach(regions::add);
                    }
                    if (regions.isEmpty()) {
                        DeploymentSpecXmlReader.illegal(msgPrefix + "all eligible zone endpoints have 'enabled' set to 'false'");
                    }
                    InstanceName instanceName = instance.map(InstanceName::from).get();
                    for (RegionName regionName : regions) {
                        targets.add(new Endpoint.Target(regionName, instanceName, 1));
                    }
                }
            }
            if (zoneEndpointType.isEmpty()) {
                Endpoint endpoint3 = new Endpoint(endpointId.orElse("default"), containerId, level, targets);
                if (endpointsById.containsKey(endpoint3.endpointId())) {
                    DeploymentSpecXmlReader.illegal("Endpoint ID '" + endpoint3.endpointId() + "' is specified multiple times");
                }
                endpointsById.put(endpoint3.endpointId(), endpoint3);
            }
        });
        endpoints.addAll(endpointsById.values());
        DeploymentSpecXmlReader.validateAndConsolidate(endpointsByZone, zoneEndpoints);
    }

    static Bcp readBcp(Element element) {
        Element bcpElement = XML.getChild((Element)element, (String)"bcp");
        if (bcpElement == null) {
            return Bcp.empty();
        }
        ArrayList<Bcp.Group> groups = new ArrayList<Bcp.Group>();
        for (Element groupElement : XML.getChildren((Element)bcpElement, (String)"group")) {
            ArrayList<Bcp.RegionMember> regions = new ArrayList<Bcp.RegionMember>();
            for (Element regionElement : XML.getChildren((Element)groupElement, (String)regionTag)) {
                RegionName region = RegionName.from((String)XML.getValue((Element)regionElement));
                double fraction = DeploymentSpecXmlReader.toDouble(XML.attribute((String)"fraction", (Element)regionElement).orElse(null), "fraction").orElse(1.0);
                regions.add(new Bcp.RegionMember(region, fraction));
            }
            Duration deadline = XML.attribute((String)"deadline", (Element)groupElement).map(value -> DeploymentSpecXmlReader.toDuration(value, "deadline")).orElse(Duration.ZERO);
            groups.add(new Bcp.Group(regions, deadline));
        }
        return new Bcp(groups);
    }

    static void validateAndConsolidate(Map<String, Map<RegionName, List<ZoneEndpoint>>> in, Map<ClusterSpec.Id, Map<ZoneId, ZoneEndpoint>> out) {
        in.forEach((cluster, regions) -> {
            List wildcards = (List)regions.remove(null);
            ZoneEndpoint wildcardZoneEndpoint = null;
            ZoneEndpoint wildcardPrivateEndpoint = null;
            if (wildcards != null) {
                for (ZoneEndpoint endpoint : wildcards) {
                    if (endpoint.isPrivateEndpoint()) {
                        if (wildcardPrivateEndpoint != null) {
                            DeploymentSpecXmlReader.illegal("Multiple private endpoints (for all regions) declared for container id '" + cluster + "'");
                        }
                        wildcardPrivateEndpoint = endpoint;
                        continue;
                    }
                    if (wildcardZoneEndpoint != null) {
                        DeploymentSpecXmlReader.illegal("Multiple zone endpoints (for all regions) declared for container id '" + cluster + "'");
                    }
                    wildcardZoneEndpoint = endpoint;
                }
            }
            for (RegionName region : regions.keySet()) {
                ZoneEndpoint zoneEndpoint = null;
                ZoneEndpoint privateEndpoint = null;
                for (ZoneEndpoint endpoint : regions.getOrDefault(region, List.of())) {
                    if (endpoint.isPrivateEndpoint()) {
                        if (privateEndpoint != null) {
                            DeploymentSpecXmlReader.illegal("Multiple private endpoints declared for container id '" + cluster + "' in region '" + region + "'");
                        }
                        privateEndpoint = endpoint;
                        continue;
                    }
                    if (zoneEndpoint != null) {
                        DeploymentSpecXmlReader.illegal("Multiple zone endpoints (without regions) declared for container id '" + cluster + "' in region '" + region + "'");
                    }
                    zoneEndpoint = endpoint;
                }
                if (wildcardZoneEndpoint != null && zoneEndpoint != null) {
                    DeploymentSpecXmlReader.illegal("Zone endpoint for container id '" + cluster + "' declared both with region '" + region + "', and for all regions.");
                }
                if (wildcardPrivateEndpoint != null && privateEndpoint != null) {
                    DeploymentSpecXmlReader.illegal("Private endpoint for container id '" + cluster + "' declared both with region '" + region + "', and for all regions.");
                }
                if (zoneEndpoint == null) {
                    zoneEndpoint = wildcardZoneEndpoint;
                }
                if (privateEndpoint == null) {
                    privateEndpoint = wildcardPrivateEndpoint;
                }
                out.computeIfAbsent(ClusterSpec.Id.from((String)cluster), __ -> new LinkedHashMap()).put(ZoneId.from((Environment)Environment.prod, (RegionName)region), new ZoneEndpoint(zoneEndpoint == null || zoneEndpoint.isPublicEndpoint(), privateEndpoint != null, privateEndpoint != null ? privateEndpoint.allowedUrns() : List.of()));
            }
            out.computeIfAbsent(ClusterSpec.Id.from((String)cluster), __ -> new LinkedHashMap()).put(null, new ZoneEndpoint(wildcardZoneEndpoint == null || wildcardZoneEndpoint.isPublicEndpoint(), wildcardPrivateEndpoint != null, wildcardPrivateEndpoint != null ? wildcardPrivateEndpoint.allowedUrns() : List.of()));
        });
    }

    static Optional<String> getZoneEndpointType(Element endpoint, Endpoint.Level level) {
        String implied;
        Optional type = XML.attribute((String)"type", (Element)endpoint);
        if (type.isPresent() && !List.of("zone", "private", "global", "application").contains(type.get())) {
            DeploymentSpecXmlReader.illegal("Illegal endpoint type '" + (String)type.get() + "'");
        }
        switch (level) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case instance: {
                String string = "global";
                break;
            }
            case application: {
                String string = implied = "application";
            }
        }
        if (type.isEmpty() || ((String)type.get()).equals(implied)) {
            return Optional.empty();
        }
        if (level == Endpoint.Level.instance && (((String)type.get()).equals("zone") || ((String)type.get()).equals("private"))) {
            return type;
        }
        throw new IllegalArgumentException("Endpoints at " + level + " level cannot be of type '" + (String)type.get() + "'");
    }

    private void validateTagOrder(Element root) {
        List<String> tags = XML.getChildren((Element)root).stream().map(Element::getTagName).toList();
        for (int i = 0; i < tags.size(); ++i) {
            if (!tags.get(i).equals(blockChangeTag)) continue;
            String constraint = "<block-change> must be placed after <test> and <staging> and before <prod>";
            if (this.containsAfter(i, testTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (this.containsAfter(i, stagingTag, tags)) {
                DeploymentSpecXmlReader.illegal(constraint);
            }
            if (!this.containsBefore(i, prodTag, tags)) continue;
            DeploymentSpecXmlReader.illegal(constraint);
        }
    }

    private boolean containsAfter(int i, String item, List<String> items) {
        return items.subList(i + 1, items.size()).contains(item);
    }

    private boolean containsBefore(int i, String item, List<String> items) {
        return items.subList(0, i).contains(item);
    }

    private long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<Integer> optionalIntegerAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private static Optional<String> stringAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        return Optional.of(value).filter(s -> !s.isBlank());
    }

    private static String requireStringAttribute(String attributeName, Element tag) {
        return DeploymentSpecXmlReader.stringAttribute(attributeName, tag).orElseThrow(() -> new IllegalArgumentException("Missing required attribute '" + attributeName + "' in '" + tag.getTagName() + "'"));
    }

    private DeploymentSpec.DeclaredZone readDeclaredZone(Environment environment, Optional<AthenzService> athenzService, Optional<String> testerFlavor, Element regionTag) {
        return new DeploymentSpec.DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), this.readActive(regionTag), athenzService, testerFlavor, this.readCloudAccount(regionTag));
    }

    private Optional<CloudAccount> readCloudAccount(Element tag) {
        return DeploymentSpecXmlReader.mostSpecificAttribute(tag, cloudAccountAttribute).map(CloudAccount::from);
    }

    private Optional<String> readGlobalServiceId(Element environmentTag) {
        String globalServiceId = environmentTag.getAttribute(globalServiceIdAttribute);
        if (globalServiceId.isEmpty()) {
            return Optional.empty();
        }
        this.deprecate(environmentTag, List.of(globalServiceIdAttribute), 7, "See https://cloud.vespa.ai/en/reference/routing#deprecated-syntax");
        return Optional.of(globalServiceId);
    }

    private List<DeploymentSpec.ChangeBlocker> readChangeBlockers(Element parent, Element globalBlockersParent) {
        ArrayList<DeploymentSpec.ChangeBlocker> changeBlockers = new ArrayList<DeploymentSpec.ChangeBlocker>();
        if (globalBlockersParent != parent) {
            for (Element tag : XML.getChildren((Element)globalBlockersParent, (String)blockChangeTag)) {
                changeBlockers.add(this.readChangeBlocker(tag));
            }
        }
        for (Element tag : XML.getChildren((Element)parent, (String)blockChangeTag)) {
            changeBlockers.add(this.readChangeBlocker(tag));
        }
        return Collections.unmodifiableList(changeBlockers);
    }

    private DeploymentSpec.ChangeBlocker readChangeBlocker(Element tag) {
        boolean blockVersions = this.trueOrMissing(tag.getAttribute("version"));
        boolean blockRevisions = this.trueOrMissing(tag.getAttribute("revision"));
        String daySpec = tag.getAttribute("days");
        String hourSpec = tag.getAttribute("hours");
        String zoneSpec = tag.getAttribute("time-zone");
        String dateStart = tag.getAttribute("from-date");
        String dateEnd = tag.getAttribute("to-date");
        return new DeploymentSpec.ChangeBlocker(blockRevisions, blockVersions, TimeWindow.from(daySpec, hourSpec, zoneSpec, dateStart, dateEnd));
    }

    private boolean trueOrMissing(String value) {
        return value == null || value.isEmpty() || value.equals("true");
    }

    private <T> T getWithFallback(Element parent, Element fallbackParent, String tagName, String attributeName, Function<String, T> mapper, T fallbackValue) {
        Element element = XML.getChild((Element)parent, (String)tagName);
        if (element == null) {
            element = XML.getChild((Element)fallbackParent, (String)tagName);
        }
        if (element == null) {
            return fallbackValue;
        }
        String attribute = element.getAttribute(attributeName);
        return attribute.isBlank() ? fallbackValue : mapper.apply(attribute);
    }

    private DeploymentSpec.UpgradePolicy readUpgradePolicy(String policy) {
        return switch (policy) {
            case "canary" -> DeploymentSpec.UpgradePolicy.canary;
            case "default" -> DeploymentSpec.UpgradePolicy.defaultPolicy;
            case "conservative" -> DeploymentSpec.UpgradePolicy.conservative;
            default -> throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of 'canary', 'default', 'conservative'");
        };
    }

    private DeploymentSpec.RevisionChange readRevisionChange(String revision) {
        return switch (revision) {
            case "when-clear" -> DeploymentSpec.RevisionChange.whenClear;
            case "when-failing" -> DeploymentSpec.RevisionChange.whenFailing;
            case "always" -> DeploymentSpec.RevisionChange.always;
            default -> throw new IllegalArgumentException("Illegal upgrade revision change policy '" + revision + "': Must be one of 'always', 'when-failing', 'when-clear'");
        };
    }

    private DeploymentSpec.RevisionTarget readRevisionTarget(String revision) {
        return switch (revision) {
            case "next" -> DeploymentSpec.RevisionTarget.next;
            case "latest" -> DeploymentSpec.RevisionTarget.latest;
            default -> throw new IllegalArgumentException("Illegal upgrade revision target '" + revision + "': Must be one of 'next', 'latest'");
        };
    }

    private DeploymentSpec.UpgradeRollout readUpgradeRollout(String rollout) {
        return switch (rollout) {
            case "separate" -> DeploymentSpec.UpgradeRollout.separate;
            case "leading" -> DeploymentSpec.UpgradeRollout.leading;
            case "simultaneous" -> DeploymentSpec.UpgradeRollout.simultaneous;
            default -> throw new IllegalArgumentException("Illegal upgrade rollout '" + rollout + "': Must be one of 'separate', 'leading', 'simultaneous'");
        };
    }

    private boolean readActive(Element regionTag) {
        String activeValue = regionTag.getAttribute("active");
        if ("".equals(activeValue)) {
            return true;
        }
        this.deprecate(regionTag, List.of("active"), 7, "See https://cloud.vespa.ai/en/reference/routing#deprecated-syntax");
        if ("true".equals(activeValue)) {
            return true;
        }
        if ("false".equals(activeValue)) {
            return false;
        }
        throw new IllegalArgumentException("Value of 'active' attribute in region tag must be 'true' or 'false' to control whether this region should receive traffic from the global endpoint of this application");
    }

    private void deprecate(Element element, List<String> attributes, int majorVersion, String message) {
        this.deprecatedElements.add(new DeploymentSpec.DeprecatedElement(majorVersion, element.getTagName(), attributes, message));
    }

    private static boolean isEmptySpec(Element root) {
        if (!XML.getChildren((Element)root).isEmpty()) {
            return false;
        }
        return root.getAttributes().getLength() == 0 || root.getAttributes().getLength() == 1 && root.hasAttribute("version");
    }

    private static Optional<String> mostSpecificAttribute(Element tag, String attributeName) {
        return Stream.iterate(tag, Objects::nonNull, Node::getParentNode).filter(Element.class::isInstance).map(Element.class::cast).flatMap(element -> DeploymentSpecXmlReader.stringAttribute(attributeName, element).stream()).findFirst();
    }

    private static Duration toDuration(String minutesSpec, String sourceDescription) {
        try {
            if (minutesSpec == null || minutesSpec.isBlank()) {
                return Duration.ZERO;
            }
            if (!(minutesSpec = minutesSpec.trim().toLowerCase()).endsWith("m")) {
                throw new IllegalArgumentException("Must end by 'm'");
            }
            try {
                return Duration.ofMinutes(Integer.parseInt(minutesSpec.substring(0, minutesSpec.length() - 1)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Must be an integer number of minutes followed by 'm'");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Illegal " + sourceDescription + " '" + minutesSpec + "'", e);
        }
    }

    private static OptionalDouble toDouble(String value, String sourceDescription) {
        try {
            if (value == null || value.isBlank()) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Illegal " + sourceDescription + " '" + value + "': Must be a number between 0.0 and 1.0");
        }
    }

    private static void illegal(String message) {
        throw new IllegalArgumentException(message);
    }
}

