/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationMetaData;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Zone;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.text.XML;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import org.w3c.dom.Element;

public interface ApplicationPackage {
    public static final String HOSTS = "hosts.xml";
    public static final String SERVICES = "services.xml";
    public static final Path SCHEMAS_DIR = Path.fromString((String)"schemas");
    public static final Path SEARCH_DEFINITIONS_DIR = Path.fromString((String)"searchdefinitions");
    public static final String COMPONENT_DIR = "components";
    public static final String SEARCHCHAINS_DIR = "search/chains";
    public static final String DOCPROCCHAINS_DIR = "docproc/chains";
    public static final String PROCESSORCHAINS_DIR = "processor/chains";
    public static final String ROUTINGTABLES_DIR = "routing/tables";
    public static final Path MODELS_DIR = Path.fromString((String)"models");
    public static final Path MODELS_GENERATED_DIR = Path.fromString((String)"models.generated");
    public static final Path MODELS_GENERATED_REPLICATED_DIR = MODELS_GENERATED_DIR.append("replicated");
    public static final Path CONSTANTS_DIR = Path.fromString((String)"constants");
    public static final String CONFIG_DEFINITIONS_DIR = "configdefinitions";
    public static final Path QUERY_PROFILES_DIR = Path.fromString((String)"search/query-profiles");
    public static final Path QUERY_PROFILE_TYPES_DIR = Path.fromString((String)"search/query-profiles/types");
    public static final Path PAGE_TEMPLATES_DIR = Path.fromString((String)"page-templates");
    public static final Path RULES_DIR = Path.fromString((String)"rules");
    public static final Path DEPLOYMENT_FILE = Path.fromString((String)"deployment.xml");
    public static final Path VALIDATION_OVERRIDES = Path.fromString((String)"validation-overrides.xml");
    public static final Path SECURITY_DIR = Path.fromString((String)"security");
    public static final String SD_NAME_SUFFIX = ".sd";
    public static final String RANKEXPRESSION_NAME_SUFFIX = ".expression";
    public static final String RULES_NAME_SUFFIX = ".sr";
    public static final String EXT_DIR = "ext";
    public static final String PERMANENT_SERVICES = "permanent-services.xml";

    @Deprecated
    public String getApplicationName();

    public ApplicationId getApplicationId();

    public Reader getServices();

    public Reader getHosts();

    default public List<String> getUserIncludeDirs() {
        throw new UnsupportedOperationException("This application package does not have special handling for user include dirs.");
    }

    default public void validateIncludeDir(String dirName) {
        throw new UnsupportedOperationException("This application package does not support validation of include dirs.");
    }

    @Deprecated
    default public Collection<NamedReader> searchDefinitionContents() {
        return this.getSchemas();
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs();

    public List<NamedReader> getFiles(Path var1, String var2, boolean var3);

    default public List<NamedReader> getFiles(Path pathFromRoot, String suffix) {
        return this.getFiles(pathFromRoot, suffix, false);
    }

    default public Optional<Integer> getMajorVersion() {
        if (this.getDeployment().isEmpty()) {
            return Optional.empty();
        }
        Element deployElement = XML.getDocument((Reader)this.getDeployment().get()).getDocumentElement();
        if (deployElement == null) {
            return Optional.empty();
        }
        String majorVersionString = deployElement.getAttribute("major-version");
        if (majorVersionString == null || majorVersionString.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(majorVersionString));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("major-version must be an integer number, not '" + majorVersionString + "'");
        }
    }

    public ApplicationFile getFile(Path var1);

    default public List<NamedReader> getQueryProfileFiles() {
        return this.getFiles(QUERY_PROFILES_DIR, ".xml");
    }

    default public List<NamedReader> getQueryProfileTypeFiles() {
        return this.getFiles(QUERY_PROFILE_TYPES_DIR, ".xml");
    }

    default public List<NamedReader> getPageTemplateFiles() {
        return this.getFiles(PAGE_TEMPLATES_DIR, ".xml");
    }

    default public ApplicationFile getClientSecurityFile() {
        return this.getFile(SECURITY_DIR.append("clients.pem"));
    }

    public String getHostSource();

    public String getServicesSource();

    public Optional<Reader> getDeployment();

    public Optional<Reader> getValidationOverrides();

    public List<ComponentInfo> getComponentsInfo(Version var1);

    public Reader getRankingExpression(String var1);

    public static String getFileName(JarEntry je) {
        String name = je.getName();
        name = name.replaceAll(".*/", "");
        return name;
    }

    public ApplicationMetaData getMetaData();

    public File getFileReference(Path var1);

    default public void validateXML() throws IOException {
        throw new UnsupportedOperationException("This application package cannot validate XML");
    }

    default public void validateXMLFor(Optional<Version> vespaVersion) throws IOException {
        throw new UnsupportedOperationException("This application package cannot validate XML");
    }

    default public void writeMetaData() throws IOException {
        throw new UnsupportedOperationException("This application package cannot write its metadata");
    }

    default public Optional<AllocatedHosts> getAllocatedHosts() {
        return Optional.empty();
    }

    default public Map<Version, FileRegistry> getFileRegistries() {
        return Collections.emptyMap();
    }

    default public Map<String, String> legacyOverrides() {
        return Collections.emptyMap();
    }

    @Deprecated
    default public Collection<NamedReader> getSearchDefinitions() {
        return this.getSchemas();
    }

    public Collection<NamedReader> getSchemas();

    default public ApplicationPackage preprocess(Zone zone, DeployLogger logger) throws IOException {
        throw new UnsupportedOperationException("This application package does not support preprocessing");
    }
}

