/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.provision.RegionName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Endpoint {
    private final Optional<String> endpointId;
    private final String containerId;
    private final Set<RegionName> regions;

    public Endpoint(Optional<String> endpointId, String containerId, Set<String> regions) {
        this.endpointId = endpointId;
        this.containerId = containerId;
        this.regions = Set.copyOf(Objects.requireNonNull(regions.stream().map(RegionName::from).collect(Collectors.toList()), "Missing 'regions' parameter"));
    }

    public String endpointId() {
        return this.endpointId.orElse(this.containerId);
    }

    public String containerId() {
        return this.containerId;
    }

    public Set<RegionName> regions() {
        return this.regions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.endpointId, endpoint.endpointId) && Objects.equals(this.containerId, endpoint.containerId) && Objects.equals(this.regions, endpoint.regions);
    }

    public int hashCode() {
        return Objects.hash(this.endpointId, this.containerId, this.regions);
    }
}

