/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.TenantName;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.JsonDecoder;
import com.yahoo.slime.JsonFormat;
import com.yahoo.slime.Slime;
import com.yahoo.text.Utf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class ApplicationMetaData {
    private final String deployedByUser;
    private final String deployedFromDir;
    private final long deployTimestamp;
    private final boolean internalRedeploy;
    private final ApplicationId applicationId;
    private final String checksum;
    private final long generation;
    private final long previousActiveGeneration;

    public ApplicationMetaData(File appDir, String deployedByUser, String deployedFromDir, Long deployTimestamp, boolean internalRedeploy, String checksum, Long generation, long previousActiveGeneration) {
        this(deployedByUser, deployedFromDir, deployTimestamp, internalRedeploy, appDir.getName(), checksum, generation, previousActiveGeneration);
    }

    public ApplicationMetaData(String deployedByUser, String deployedFromDir, Long deployTimestamp, boolean internalRedeploy, String applicationName, String checksum, Long generation, long previousActiveGeneration) {
        this(deployedByUser, deployedFromDir, deployTimestamp, internalRedeploy, ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)applicationName), (InstanceName)InstanceName.from((String)"default")), checksum, generation, previousActiveGeneration);
    }

    public ApplicationMetaData(String deployedByUser, String deployedFromDir, Long deployTimestamp, boolean internalRedeploy, ApplicationId applicationId, String checksum, Long generation, long previousActiveGeneration) {
        this.deployedByUser = deployedByUser;
        this.deployedFromDir = deployedFromDir;
        this.deployTimestamp = deployTimestamp;
        this.internalRedeploy = internalRedeploy;
        this.applicationId = applicationId;
        this.checksum = checksum;
        this.generation = generation;
        this.previousActiveGeneration = previousActiveGeneration;
    }

    public String getApplicationName() {
        return this.applicationId.application().toString();
    }

    public String getDeployedByUser() {
        return this.deployedByUser;
    }

    public String getDeployPath() {
        return this.deployedFromDir;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Long getDeployTimestamp() {
        return this.deployTimestamp;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public boolean isInternalRedeploy() {
        return this.internalRedeploy;
    }

    public String getCheckSum() {
        return this.checksum;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public long getPreviousActiveGeneration() {
        return this.previousActiveGeneration;
    }

    public String toString() {
        return this.deployedByUser + ", " + this.deployedFromDir + ", " + this.deployTimestamp + ", " + this.generation + ", " + this.checksum + ", " + this.previousActiveGeneration;
    }

    public static ApplicationMetaData fromJsonString(String jsonString) {
        try {
            Slime data = new Slime();
            new JsonDecoder().decode(data, Utf8.toBytes((String)jsonString));
            Cursor root = data.get();
            Inspector deploy = root.field("deploy");
            Inspector app = root.field("application");
            ApplicationId applicationId = app.field("id").valid() ? ApplicationId.fromSerializedForm((String)app.field("id").asString()) : ApplicationId.from((TenantName)TenantName.defaultName(), (ApplicationName)ApplicationName.from((String)app.field("name").asString()), (InstanceName)InstanceName.from((String)"default"));
            return new ApplicationMetaData(deploy.field("user").asString(), deploy.field("from").asString(), (Long)deploy.field("timestamp").asLong(), ApplicationMetaData.booleanField("internalRedeploy", false, deploy), applicationId, app.field("checksum").asString(), (Long)app.field("generation").asLong(), app.field("previousActiveGeneration").asLong());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing json metadata", e);
        }
    }

    public Slime getSlime() {
        Slime slime = new Slime();
        Cursor meta = slime.setObject();
        Cursor deploy = meta.setObject("deploy");
        deploy.setString("user", this.deployedByUser);
        deploy.setString("from", this.deployedFromDir);
        deploy.setLong("timestamp", this.deployTimestamp);
        deploy.setBool("internalRedeploy", this.internalRedeploy);
        Cursor app = meta.setObject("application");
        app.setString("id", this.applicationId.serializedForm());
        app.setString("name", this.applicationId.application().value());
        app.setString("checksum", this.checksum);
        app.setLong("generation", this.generation);
        app.setLong("previousActiveGeneration", this.previousActiveGeneration);
        return slime;
    }

    private static boolean booleanField(String fieldName, boolean defaultValue, Inspector object) {
        Inspector value = object.field(fieldName);
        if (!value.valid()) {
            return defaultValue;
        }
        return value.asBool();
    }

    public String asJsonString() {
        Slime slime = this.getSlime();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new JsonFormat(false).encode((OutputStream)baos, slime);
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to encode metadata", e);
        }
    }
}

