/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api.xml;

import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class DeploymentSpecXmlReader {
    private static final String majorVersionTag = "major-version";
    private static final String testTag = "test";
    private static final String stagingTag = "staging";
    private static final String blockChangeTag = "block-change";
    private static final String prodTag = "prod";
    private final boolean validate;

    public DeploymentSpecXmlReader() {
        this(true);
    }

    public DeploymentSpecXmlReader(boolean validate) {
        this.validate = validate;
    }

    public DeploymentSpec read(Reader reader) {
        try {
            return this.read(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public DeploymentSpec read(String xmlForm) {
        ArrayList<DeploymentSpec.Step> steps = new ArrayList<DeploymentSpec.Step>();
        Optional<String> globalServiceId = Optional.empty();
        Element root = XML.getDocument((String)xmlForm).getDocumentElement();
        if (this.validate) {
            this.validateTagOrder(root);
        }
        for (Element environmentTag : XML.getChildren((Element)root)) {
            if (!this.isEnvironmentName(environmentTag.getTagName())) continue;
            Environment environment = Environment.from((String)environmentTag.getTagName());
            if (environment == Environment.prod) {
                for (Element stepTag : XML.getChildren((Element)environmentTag)) {
                    Optional<AthenzService> athenzService = this.stringAttribute("athenz-service", environmentTag).map(AthenzService::from);
                    if (stepTag.getTagName().equals("delay")) {
                        steps.add(new DeploymentSpec.Delay(Duration.ofSeconds(this.longAttribute("hours", stepTag) * 60L * 60L + this.longAttribute("minutes", stepTag) * 60L + this.longAttribute("seconds", stepTag))));
                        continue;
                    }
                    if (stepTag.getTagName().equals("parallel")) {
                        ArrayList<DeploymentSpec.DeclaredZone> zones = new ArrayList<DeploymentSpec.DeclaredZone>();
                        for (Element regionTag : XML.getChildren((Element)stepTag)) {
                            zones.add(this.readDeclaredZone(environment, athenzService, regionTag));
                        }
                        steps.add(new DeploymentSpec.ParallelZones(zones));
                        continue;
                    }
                    steps.add(this.readDeclaredZone(environment, athenzService, stepTag));
                }
            } else {
                steps.add(new DeploymentSpec.DeclaredZone(environment));
            }
            if (environment == Environment.prod) {
                globalServiceId = this.readGlobalServiceId(environmentTag);
                continue;
            }
            if (!this.readGlobalServiceId(environmentTag).isPresent()) continue;
            throw new IllegalArgumentException("Attribute 'global-service-id' is only valid on 'prod' tag.");
        }
        Optional<AthenzDomain> athenzDomain = this.stringAttribute("athenz-domain", root).map(AthenzDomain::from);
        Optional<AthenzService> athenzService = this.stringAttribute("athenz-service", root).map(AthenzService::from);
        return new DeploymentSpec(globalServiceId, this.readUpgradePolicy(root), this.optionalIntegerAttribute(majorVersionTag, root), this.readChangeBlockers(root), steps, xmlForm, athenzDomain, athenzService, this.readNotifications(root));
    }

    private Notifications readNotifications(Element root) {
        Element notificationsElement = XML.getChild((Element)root, (String)"notifications");
        if (notificationsElement == null) {
            return Notifications.none();
        }
        Notifications.When defaultWhen = this.stringAttribute("when", notificationsElement).map(Notifications.When::fromValue).orElse(Notifications.When.failingCommit);
        HashMap<Notifications.When, List<String>> emailAddresses = new HashMap<Notifications.When, List<String>>();
        HashMap<Notifications.When, List<Notifications.Role>> emailRoles = new HashMap<Notifications.When, List<Notifications.Role>>();
        for (Notifications.When when : Notifications.When.values()) {
            emailAddresses.put(when, new ArrayList());
            emailRoles.put(when, new ArrayList());
        }
        for (Element emailElement : XML.getChildren((Element)notificationsElement, (String)"email")) {
            Optional<String> addressAttribute = this.stringAttribute("address", emailElement);
            Optional<Notifications.Role> roleAttribute = this.stringAttribute("role", emailElement).map(Notifications.Role::fromValue);
            Notifications.When when = this.stringAttribute("when", emailElement).map(Notifications.When::fromValue).orElse(defaultWhen);
            if (addressAttribute.isPresent() == roleAttribute.isPresent()) {
                throw new IllegalArgumentException("Exactly one of 'role' and 'address' must be present in 'email' elements.");
            }
            addressAttribute.ifPresent(address -> ((List)emailAddresses.get((Object)when)).add(address));
            roleAttribute.ifPresent(role -> ((List)emailRoles.get((Object)when)).add(role));
        }
        return Notifications.of(emailAddresses, emailRoles);
    }

    private void validateTagOrder(Element root) {
        List<String> tags = XML.getChildren((Element)root).stream().map(Element::getTagName).collect(Collectors.toList());
        for (int i = 0; i < tags.size(); ++i) {
            if (!((String)tags.get(i)).equals(blockChangeTag)) continue;
            String constraint = "<block-change> must be placed after <test> and <staging> and before <prod>";
            if (this.containsAfter(i, testTag, tags)) {
                throw new IllegalArgumentException(constraint);
            }
            if (this.containsAfter(i, stagingTag, tags)) {
                throw new IllegalArgumentException(constraint);
            }
            if (!this.containsBefore(i, prodTag, tags)) continue;
            throw new IllegalArgumentException(constraint);
        }
    }

    private boolean containsAfter(int i, String item, List<String> items) {
        return items.subList(i + 1, items.size()).contains(item);
    }

    private boolean containsBefore(int i, String item, List<String> items) {
        return items.subList(0, i).contains(item);
    }

    private long longAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<Integer> optionalIntegerAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Expected an integer for attribute '" + attributeName + "' but got '" + value + "'");
        }
    }

    private Optional<String> stringAttribute(String attributeName, Element tag) {
        String value = tag.getAttribute(attributeName);
        return Optional.ofNullable(value).filter(s -> !s.equals(""));
    }

    private boolean isEnvironmentName(String tagName) {
        return tagName.equals(testTag) || tagName.equals(stagingTag) || tagName.equals(prodTag);
    }

    private DeploymentSpec.DeclaredZone readDeclaredZone(Environment environment, Optional<AthenzService> athenzService, Element regionTag) {
        return new DeploymentSpec.DeclaredZone(environment, Optional.of(RegionName.from((String)XML.getValue((Element)regionTag).trim())), this.readActive(regionTag), athenzService);
    }

    private Optional<String> readGlobalServiceId(Element environmentTag) {
        String globalServiceId = environmentTag.getAttribute("global-service-id");
        if (globalServiceId == null || globalServiceId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(globalServiceId);
    }

    private List<DeploymentSpec.ChangeBlocker> readChangeBlockers(Element root) {
        ArrayList<DeploymentSpec.ChangeBlocker> changeBlockers = new ArrayList<DeploymentSpec.ChangeBlocker>();
        for (Element tag : XML.getChildren((Element)root)) {
            if (!blockChangeTag.equals(tag.getTagName()) && !"block-upgrade".equals(tag.getTagName())) continue;
            boolean blockVersions = tag.getTagName().equals("block-upgrade") || this.trueOrMissing(tag.getAttribute("version"));
            boolean blockRevisions = this.trueOrMissing(tag.getAttribute("revision")) && !tag.getTagName().equals("block-upgrade");
            String daySpec = tag.getAttribute("days");
            String hourSpec = tag.getAttribute("hours");
            String zoneSpec = tag.getAttribute("time-zone");
            if (zoneSpec.isEmpty()) {
                zoneSpec = "UTC";
            }
            changeBlockers.add(new DeploymentSpec.ChangeBlocker(blockRevisions, blockVersions, TimeWindow.from(daySpec, hourSpec, zoneSpec)));
        }
        return Collections.unmodifiableList(changeBlockers);
    }

    private boolean trueOrMissing(String value) {
        return value == null || value.isEmpty() || value.equals("true");
    }

    private DeploymentSpec.UpgradePolicy readUpgradePolicy(Element root) {
        String policy;
        Element upgradeElement = XML.getChild((Element)root, (String)"upgrade");
        if (upgradeElement == null) {
            return DeploymentSpec.UpgradePolicy.defaultPolicy;
        }
        switch (policy = upgradeElement.getAttribute("policy")) {
            case "canary": {
                return DeploymentSpec.UpgradePolicy.canary;
            }
            case "default": {
                return DeploymentSpec.UpgradePolicy.defaultPolicy;
            }
            case "conservative": {
                return DeploymentSpec.UpgradePolicy.conservative;
            }
        }
        throw new IllegalArgumentException("Illegal upgrade policy '" + policy + "': Must be one of " + Arrays.toString((Object[])DeploymentSpec.UpgradePolicy.values()));
    }

    private boolean readActive(Element regionTag) {
        String activeValue = regionTag.getAttribute("active");
        if ("true".equals(activeValue)) {
            return true;
        }
        if ("false".equals(activeValue)) {
            return false;
        }
        throw new IllegalArgumentException("Region tags must have an 'active' attribute set to 'true' or 'false' to control whether the region should receive production traffic");
    }
}

