/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.LeafNode;
import com.yahoo.config.ModelNode;
import com.yahoo.config.ModelReference;
import com.yahoo.config.NodeVector;
import com.yahoo.config.PathNode;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.UrlNode;
import com.yahoo.config.UrlReference;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LeafNodeVector<REAL, NODE extends LeafNode<REAL>>
extends NodeVector<NODE> {
    private final List<REAL> realValues;

    public LeafNodeVector(List<REAL> values, NODE defaultNode) {
        assert (defaultNode != null) : "The default node cannot be null";
        if (LeafNodeVector.createNew(defaultNode) == null) {
            throw new NullPointerException("Unable to duplicate the default node.");
        }
        for (REAL value : values) {
            NODE node = LeafNodeVector.createNew(defaultNode);
            ((LeafNode)node).value = value;
            this.vector.add(node);
        }
        this.realValues = LeafNodeVector.realList(this.vector);
    }

    public List<REAL> asList() {
        return this.realValues;
    }

    private static <NODE extends LeafNode<?>> NODE createNew(NODE defaultNode) {
        return (NODE)((LeafNode)defaultNode.clone());
    }

    private static <REAL, NODE extends LeafNode<REAL>> List<REAL> realList(List<NODE> nodes) {
        ArrayList reals = new ArrayList();
        for (LeafNode node : nodes) {
            reals.add(node.value());
        }
        return Collections.unmodifiableList(reals);
    }

    public static LeafNodeVector<FileReference, FileNode> createFileNodeVector(Collection<String> values) {
        ArrayList<FileReference> fileReferences = new ArrayList<FileReference>();
        for (String s : values) {
            fileReferences.add(new FileReference(ReferenceNode.stripQuotes(s)));
        }
        return new LeafNodeVector<FileReference, FileNode>(fileReferences, new FileNode());
    }

    public static LeafNodeVector<Path, PathNode> createPathNodeVector(Collection<FileReference> values) {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (FileReference fileReference : values) {
            paths.add(Paths.get(fileReference.value(), new String[0]));
        }
        return new LeafNodeVector<Path, PathNode>(paths, new PathNode());
    }

    public static LeafNodeVector<File, UrlNode> createUrlNodeVector(Collection<UrlReference> values) {
        ArrayList<File> files = new ArrayList<File>();
        for (UrlReference urlReference : values) {
            files.add(new File(urlReference.value()));
        }
        return new LeafNodeVector<File, UrlNode>(files, new UrlNode());
    }

    public static LeafNodeVector<Path, ModelNode> createModelNodeVector(Collection<ModelReference> values) {
        ArrayList<Path> modelPaths = new ArrayList<Path>();
        for (ModelReference modelReference : values) {
            modelPaths.add(modelReference.value());
        }
        return new LeafNodeVector<Path, ModelNode>(modelPaths, new ModelNode());
    }
}

