/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.LeafNode;
import com.yahoo.config.Node;
import com.yahoo.config.NodeVector;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class InnerNode
extends Node {
    public String toString() {
        return InnerNode.mkString(ConfigInstance.serialize(this), "\n");
    }

    private static <T> String mkString(Collection<T> collection, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T elem : collection) {
            if (!first) {
                sb.append(sep);
            }
            first = false;
            sb.append(elem);
        }
        return sb.toString();
    }

    @Override
    public void postInitialize(String configId) {
        Map<String, Node> children = this.getChildrenWithVectorsFlattened();
        for (Node node : children.values()) {
            node.postInitialize(configId);
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof InnerNode) || other.getClass() != this.getClass()) {
            return false;
        }
        Collection<Object> children = this.getChildren().values();
        Collection<Object> otherChildren = ((InnerNode)other).getChildren().values();
        Iterator<Object> e1 = children.iterator();
        Iterator<Object> e2 = otherChildren.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o2;
            Object o1 = e1.next();
            if (Objects.equals(o1, o2 = e2.next())) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    public int hashCode() {
        int res = 17;
        for (Object child : this.getChildren().values()) {
            res = 31 * res + child.hashCode();
        }
        return res;
    }

    protected final Map<String, Object> getChildren() {
        Field[] fields;
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            Object fieldValue;
            field.setAccessible(true);
            try {
                fieldValue = field.get(this);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationRuntimeException(e);
            }
            if (!(fieldValue instanceof Node) && !(fieldValue instanceof NodeVector) && !(fieldValue instanceof Map)) continue;
            ret.put(field.getName(), fieldValue);
        }
        return ret;
    }

    protected final Map<String, Node> getChildrenWithVectorsFlattened() {
        LinkedHashMap<String, Node> ret = new LinkedHashMap<String, Node>();
        Map<String, Object> children = this.getChildren();
        for (Map.Entry<String, Object> childEntry : children.entrySet()) {
            String name = childEntry.getKey();
            Object child = childEntry.getValue();
            if (child instanceof NodeVector) {
                InnerNode.addNodeVectorEntries(ret, name, (NodeVector)child);
                continue;
            }
            if (child instanceof Map) {
                InnerNode.addMapEntries(ret, name, (Map)child);
                continue;
            }
            if (!(child instanceof Node)) continue;
            ret.put(name, (Node)child);
        }
        return ret;
    }

    private static void addMapEntries(Map<String, Node> ret, String name, Map<String, Node> map) {
        for (Map.Entry<String, Node> entry : map.entrySet()) {
            ret.put(name + "{" + entry.getKey() + "}", entry.getValue());
        }
    }

    private static void addNodeVectorEntries(Map<String, Node> ret, String name, NodeVector<?> vector) {
        for (int j = 0; j < vector.length(); ++j) {
            ret.put(name + "[" + j + "]", (Node)vector.get(j));
        }
    }

    protected static Map<String, LeafNode<?>> getAllDescendantLeafNodes(InnerNode node) {
        return InnerNode.getAllDescendantLeafNodes("", node);
    }

    private static Map<String, LeafNode<?>> getAllDescendantLeafNodes(String parentName, InnerNode node) {
        LinkedHashMap ret = new LinkedHashMap();
        Object prefix = parentName.isEmpty() ? "" : parentName + ".";
        Map<String, Node> children = node.getChildrenWithVectorsFlattened();
        for (Map.Entry<String, Node> childEntry : children.entrySet()) {
            String name = childEntry.getKey();
            String prefixedName = (String)prefix + name;
            name.replaceAll("\\[.*", "");
            Node child = childEntry.getValue();
            if (child instanceof LeafNode) {
                ret.put(prefixedName, (LeafNode)child);
                continue;
            }
            if (!(child instanceof InnerNode)) continue;
            ret.putAll(InnerNode.getAllDescendantLeafNodes(prefixedName, (InnerNode)child));
        }
        return ret;
    }
}

