/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileReference;
import com.yahoo.config.UrlReference;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class ModelReference {
    private final Optional<String> modelId;
    private final Optional<UrlReference> url;
    private final Optional<FileReference> path;
    private final Path resolved;
    private final Optional<String> secretRef;

    private ModelReference(Optional<String> modelId, Optional<UrlReference> url, Optional<String> secretRef, Optional<FileReference> path, Path resolved) {
        this.modelId = modelId;
        this.url = url;
        this.secretRef = secretRef;
        this.path = path;
        this.resolved = resolved;
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public Optional<String> modelId() {
        return this.modelId;
    }

    public Optional<UrlReference> url() {
        return this.url;
    }

    public Optional<FileReference> path() {
        return this.path;
    }

    public Optional<String> secretRef() {
        return this.secretRef;
    }

    public Path value() {
        return this.resolved;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelReference)) {
            return false;
        }
        ModelReference other = (ModelReference)o;
        if (!Objects.equals(this.modelId, other.modelId)) {
            return false;
        }
        if (!Objects.equals(this.url, other.url)) {
            return false;
        }
        if (!Objects.equals(this.secretRef, other.secretRef)) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        return Objects.equals(this.resolved, other.resolved);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.url, this.secretRef, this.path, this.resolved);
    }

    public String toString() {
        if (this.resolved != null) {
            return this.resolved.toString();
        }
        return this.modelId.orElse("\"\"") + " " + this.url.map(UrlReference::value).orElse("\"\"") + " " + this.secretRef.map(arg_0 -> ModelReference.lambda$toString$0("%s ", arg_0)).orElse("") + this.path.map(FileReference::value).orElse("\"\"");
    }

    public static ModelReference valueOf(String s) {
        String[] parts = s.split(" ");
        if (parts.length == 1) {
            return ModelReference.resolved(Path.of(s, new String[0]));
        }
        if (parts.length == 3) {
            return ModelReference.unresolved(parts[0].equals("\"\"") ? Optional.empty() : Optional.of(parts[0]), parts[1].equals("\"\"") ? Optional.empty() : Optional.of(new UrlReference(parts[1])), parts[2].equals("\"\"") ? Optional.empty() : Optional.of(new FileReference(parts[2])));
        }
        if (parts.length == 4) {
            return ModelReference.unresolved(parts[0].equals("\"\"") ? Optional.empty() : Optional.of(parts[0]), parts[1].equals("\"\"") ? Optional.empty() : Optional.of(new UrlReference(parts[1])), parts[2].equals("\"\"") ? Optional.empty() : Optional.of(parts[2]), parts[3].equals("\"\"") ? Optional.empty() : Optional.of(new FileReference(parts[3])));
        }
        throw new IllegalArgumentException("Unexpected model reference string '" + s + "'");
    }

    public static ModelReference unresolved(String modelId) {
        return new ModelReference(Optional.of(modelId), Optional.empty(), Optional.empty(), Optional.empty(), null);
    }

    public static ModelReference unresolved(UrlReference url) {
        return new ModelReference(Optional.empty(), Optional.of(url), Optional.empty(), Optional.empty(), null);
    }

    public static ModelReference unresolved(FileReference path) {
        return new ModelReference(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(path), null);
    }

    public static ModelReference unresolved(Optional<String> modelId, Optional<UrlReference> url, Optional<FileReference> path) {
        return ModelReference.unresolved(modelId, url, Optional.empty(), path);
    }

    public static ModelReference unresolved(Optional<String> modelId, Optional<UrlReference> url, Optional<String> secretRef, Optional<FileReference> path) {
        if (modelId.isEmpty() && url.isEmpty() && path.isEmpty()) {
            throw new IllegalArgumentException("A model reference must have either a model id, url or path");
        }
        return new ModelReference(modelId, url, secretRef, path, null);
    }

    public static ModelReference resolved(Path path) {
        return new ModelReference(null, null, null, null, Objects.requireNonNull(path));
    }

    private static /* synthetic */ String lambda$toString$0(String rec$, Object xva$0) {
        return "%s ".formatted(xva$0);
    }
}

