/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileReference;
import com.yahoo.config.UrlReference;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;

public class ModelReference {
    private final Optional<String> modelId;
    private final Optional<UrlReference> url;
    private final Optional<FileReference> path;
    private final Path resolved;

    public ModelReference(Path resolved) {
        this.modelId = Optional.empty();
        this.url = Optional.empty();
        this.path = Optional.empty();
        this.resolved = resolved;
    }

    public ModelReference(Optional<String> modelId, Optional<UrlReference> url, Optional<FileReference> path) {
        if (modelId.isEmpty() && url.isEmpty() && path.isEmpty()) {
            throw new IllegalArgumentException("A model reference must have either a model id, url or path");
        }
        this.modelId = modelId;
        this.url = url;
        this.path = path;
        this.resolved = null;
    }

    public Optional<String> modelId() {
        return this.modelId;
    }

    public Optional<UrlReference> url() {
        return this.url;
    }

    public Optional<FileReference> path() {
        return this.path;
    }

    public ModelReference withModelId(Optional<String> modelId) {
        return new ModelReference(modelId, this.url, this.path);
    }

    public ModelReference withUrl(Optional<UrlReference> url) {
        return new ModelReference(this.modelId, url, this.path);
    }

    public ModelReference withPath(Optional<FileReference> path) {
        return new ModelReference(this.modelId, this.url, path);
    }

    public Path value() {
        if (this.resolved != null) {
            return this.resolved;
        }
        if (this.url.isPresent() && new File(this.url.get().value()).exists()) {
            return Path.of(this.url.get().value(), new String[0]);
        }
        if (this.path.isPresent()) {
            return Path.of(this.path.get().value(), new String[0]);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelReference)) {
            return false;
        }
        ModelReference other = (ModelReference)o;
        if (!this.modelId.equals(other.modelId)) {
            return false;
        }
        if (!this.url.equals(other.url)) {
            return false;
        }
        return this.path.equals(other.path);
    }

    public int hashCode() {
        return Objects.hash(this.modelId, this.url, this.path);
    }

    public String toString() {
        return this.modelId.orElse("") + " " + this.url.map(v -> v.value()).orElse("") + " " + this.path.map(v -> v.value()).orElse("");
    }

    public static ModelReference fromModelId(String modelId) {
        return new ModelReference(Optional.of(modelId), Optional.empty(), Optional.empty());
    }

    public static ModelReference fromUrl(String url) {
        return new ModelReference(Optional.empty(), Optional.of(new UrlReference(url)), Optional.empty());
    }

    public static ModelReference fromPath(String path) {
        return new ModelReference(Optional.empty(), Optional.empty(), Optional.of(new FileReference(path)));
    }

    public static ModelReference valueOf(Path path) {
        return new ModelReference(path);
    }

    public static ModelReference valueOf(String s) {
        String[] parts = s.split(" ");
        if (parts.length == 1) {
            return new ModelReference(Path.of(s, new String[0]));
        }
        if (parts.length == 3) {
            return new ModelReference(parts[0].equals("") ? Optional.empty() : Optional.of(parts[0]), parts[1].equals("") ? Optional.empty() : Optional.of(new UrlReference(parts[1])), parts[2].equals("") ? Optional.empty() : Optional.of(new FileReference(parts[2])));
        }
        throw new IllegalArgumentException("Unexpected model string '" + s + "'");
    }
}

