/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.ModelReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModelNode
extends LeafNode<Path> {
    private final ModelReference reference;

    public ModelNode() {
        this.value = null;
        this.reference = null;
    }

    public ModelNode(ModelReference modelReference) {
        super(true);
        this.value = modelReference.value();
        this.reference = modelReference;
    }

    @Override
    public String getValue() {
        return ((Path)this.value).toString();
    }

    @Override
    public String toString() {
        return this.value == null ? "(null)" : "\"" + this.getValue() + "\"";
    }

    @Override
    protected boolean doSetValue(String stringVal) {
        throw new UnsupportedOperationException();
    }

    public ModelReference getModelReference() {
        return this.reference;
    }

    public static List<ModelReference> toModelReferences(List<ModelNode> modelNodes) {
        ArrayList<ModelReference> modelReferences = new ArrayList<ModelReference>();
        for (ModelNode modelNode : modelNodes) {
            modelReferences.add(modelNode.getModelReference());
        }
        return modelReferences;
    }

    public static Map<String, ModelReference> toModelReferenceMap(Map<String, ModelNode> nodeMap) {
        LinkedHashMap<String, ModelReference> referenceMap = new LinkedHashMap<String, ModelReference>();
        for (Map.Entry<String, ModelNode> entry : nodeMap.entrySet()) {
            referenceMap.put(entry.getKey(), entry.getValue().getModelReference());
        }
        return referenceMap;
    }
}

