/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChangesRequiringRestart {
    private final ArrayList<ReportLine> report = new ArrayList();
    private final String componentName;

    public ChangesRequiringRestart(String componentName) {
        this.componentName = componentName;
    }

    public String getName() {
        return this.componentName;
    }

    public ChangesRequiringRestart compare(Node from, Node to, String name, String comment) {
        if (!from.equals(to)) {
            this.report.add(new ReportLine(name, from, to, comment));
        }
        return this;
    }

    public void mergeChanges(String prefix, ChangesRequiringRestart childReport) {
        for (ReportLine line : childReport.getReportLines()) {
            line.addNamePrefix(prefix);
            this.report.add(line);
        }
    }

    public ChangesRequiringRestart compareArray(List<? extends Node> from, List<? extends Node> to, String name, String comment, CompareFunc func) {
        if (!from.equals(to)) {
            int i;
            int commonElements = Math.min(from.size(), to.size());
            for (i = 0; i < commonElements; ++i) {
                ChangesRequiringRestart childReport = func.getChangesRequiringRestart(from.get(i), to.get(i));
                String prefix = childReport.componentName + "[" + i + "]";
                this.mergeChanges(prefix, childReport);
            }
            for (i = commonElements; i < from.size(); ++i) {
                this.report.add(new ReportLine(name + "[" + i + "]", from.get(i), null, comment));
            }
            for (i = commonElements; i < to.size(); ++i) {
                this.report.add(new ReportLine(name + "[" + i + "]", null, to.get(i), comment));
            }
        }
        return this;
    }

    public ChangesRequiringRestart compareMap(Map<String, ? extends Node> from, Map<String, ? extends Node> to, String name, String comment, CompareFunc func) {
        if (!from.equals(to)) {
            for (String key : from.keySet()) {
                if (to.containsKey(key)) {
                    ChangesRequiringRestart childReport = func.getChangesRequiringRestart(from.get(key), to.get(key));
                    String prefix = childReport.componentName + "{" + key + "}";
                    this.mergeChanges(prefix, childReport);
                    continue;
                }
                this.report.add(new ReportLine(name + "{" + key + "}", from.get(key), null, comment));
            }
            for (String key : to.keySet()) {
                if (from.containsKey(key)) continue;
                this.report.add(new ReportLine(name + "{" + key + "}", null, to.get(key), comment));
            }
        }
        return this;
    }

    List<ReportLine> getReportLines() {
        return this.report;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return this.report.stream().map(line -> line.toString(indent, this.componentName + ".")).collect(Collectors.joining("\n"));
    }

    public boolean needsRestart() {
        return !this.report.isEmpty();
    }

    static class ReportLine {
        private String name;
        private final Node from;
        private final Node to;
        private final String comment;

        public ReportLine(String name, Node from, Node to, String comment) {
            this.name = name;
            this.from = from;
            this.to = to;
            this.comment = comment;
        }

        public void addNamePrefix(String prefix) {
            this.name = !this.name.isEmpty() ? prefix + "." + this.name : prefix;
        }

        private String getCommentAndName(String indent, String namePrefix) {
            return indent + (String)(this.comment.isEmpty() ? "" : "# " + this.comment.replace("\n", "\n" + indent + "# ") + "\n" + indent) + namePrefix + this.name;
        }

        private static String formatValue(String indent, Node n) {
            Object str = n.toString();
            if (((String)str).contains("\n")) {
                str = "\n" + indent + "  { " + ((String)str).replace("\n", "\n" + indent + "    ") + " }";
            }
            return str;
        }

        public String toString() {
            return this.toString("", "");
        }

        public String toString(String indent, String namePrefix) {
            if (this.from == null) {
                return this.getCommentAndName(indent, namePrefix) + " was added with value " + ReportLine.formatValue(indent, this.to);
            }
            if (this.to == null) {
                return this.getCommentAndName(indent, namePrefix) + " with value " + ReportLine.formatValue(indent, this.from) + " was removed";
            }
            return this.getCommentAndName(indent, namePrefix) + " has changed from " + ReportLine.formatValue(indent, this.from) + " to " + ReportLine.formatValue(indent, this.to);
        }
    }

    public static interface CompareFunc {
        public ChangesRequiringRestart getChangesRequiringRestart(Node var1, Node var2);
    }
}

