/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.Serializer;
import edu.umd.cs.findbugs.annotations.NonNull;

public class DoubleNode
extends LeafNode<Double> {
    public DoubleNode() {
    }

    public DoubleNode(double value) {
        super(true);
        this.value = value;
    }

    @Override
    public Double value() {
        return (Double)this.value;
    }

    @Override
    public String getValue() {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    protected boolean doSetValue(@NonNull String value) {
        try {
            this.value = Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    void serialize(String name, Serializer serializer) {
        serializer.serialize(name, (Double)this.value);
    }

    @Override
    void serialize(Serializer serializer) {
        serializer.serialize((Double)this.value);
    }
}

