/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileReference;
import com.yahoo.config.LeafNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PathNode
extends LeafNode<Path> {
    private final FileReference fileReference;

    public PathNode() {
        this.fileReference = null;
    }

    public PathNode(FileReference fileReference) {
        super(true);
        this.value = Path.of(fileReference.value(), new String[0]);
        if (((Path)this.value).normalize().toString().startsWith("..")) {
            throw new IllegalArgumentException("path may not start with '..', but got :" + this.value);
        }
        this.fileReference = fileReference;
    }

    @Override
    public Path value() {
        return (Path)this.value;
    }

    @Override
    public String getValue() {
        return ((Path)this.value).toString();
    }

    @Override
    public String toString() {
        return this.value == null ? "(null)" : "\"" + this.getValue() + "\"";
    }

    @Override
    protected boolean doSetValue(String stringVal) {
        throw new UnsupportedOperationException("doSetValue should not be necessary since the library anymore!");
    }

    public FileReference getFileReference() {
        return this.fileReference;
    }

    public static List<FileReference> toFileReferences(List<PathNode> pathNodes) {
        ArrayList<FileReference> fileReferences = new ArrayList<FileReference>();
        for (PathNode pathNode : pathNodes) {
            fileReferences.add(pathNode.getFileReference());
        }
        return fileReferences;
    }

    public static Map<String, FileReference> toFileReferenceMap(Map<String, PathNode> map) {
        LinkedHashMap<String, FileReference> ret = new LinkedHashMap<String, FileReference>();
        for (Map.Entry<String, PathNode> e : map.entrySet()) {
            ret.put(e.getKey(), e.getValue().getFileReference());
        }
        return ret;
    }
}

