/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.Serializer;
import edu.umd.cs.findbugs.annotations.NonNull;

public class LongNode
extends LeafNode<Long> {
    public LongNode() {
    }

    public LongNode(long value) {
        super(true);
        this.value = value;
    }

    @Override
    public Long value() {
        return (Long)this.value;
    }

    @Override
    public String getValue() {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    protected boolean doSetValue(@NonNull String value) {
        try {
            this.value = Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    void serialize(String name, Serializer serializer) {
        serializer.serialize(name, (Long)this.value);
    }

    @Override
    void serialize(Serializer serializer) {
        serializer.serialize((Long)this.value);
    }
}

