/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.Serializer;

public class IntegerNode
extends LeafNode<Integer> {
    public IntegerNode() {
    }

    public IntegerNode(int value) {
        super(true);
        this.value = value;
    }

    @Override
    public Integer value() {
        return (Integer)this.value;
    }

    @Override
    public String getValue() {
        return "" + this.value;
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    @Override
    protected boolean doSetValue(String value) {
        try {
            this.value = Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    void serialize(String name, Serializer serializer) {
        serializer.serialize(name, (Integer)this.value);
    }

    @Override
    void serialize(Serializer serializer) {
        serializer.serialize((Integer)this.value);
    }
}

