/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.Node;
import com.yahoo.config.Serializer;
import edu.umd.cs.findbugs.annotations.NonNull;

public abstract class LeafNode<T>
extends Node
implements Cloneable {
    protected boolean initialized;
    protected T value;

    protected LeafNode() {
        this.initialized = false;
    }

    protected LeafNode(boolean initialized) {
        this.initialized = initialized;
    }

    public T value() {
        return this.value;
    }

    public abstract String toString();

    public abstract String getValue();

    protected final boolean setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value is not allowed");
        }
        return this.doSetValue(value);
    }

    protected abstract boolean doSetValue(@NonNull String var1);

    @Override
    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigurationRuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof LeafNode)) {
            return false;
        }
        LeafNode other = (LeafNode)o;
        return this.value == null ? other.value == null : this.value().equals(other.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    void serialize(String name, Serializer serializer) {
        serializer.serialize(name, this.getValue());
    }

    void serialize(Serializer serializer) {
        serializer.serialize(this.getValue());
    }
}

