/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;
import com.yahoo.config.UrlReference;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UrlNode
extends LeafNode<File> {
    private final UrlReference url;

    public UrlNode() {
        this.url = null;
    }

    public UrlNode(UrlReference url) {
        super(true);
        this.url = url;
        this.value = new File(url.value());
    }

    @Override
    public File value() {
        return (File)this.value;
    }

    @Override
    public String toString() {
        return this.value == null ? "(null)" : '\"' + this.getValue() + '\"';
    }

    @Override
    public String getValue() {
        return ((File)this.value).toString();
    }

    @Override
    protected boolean doSetValue(@NonNull String value) {
        throw new UnsupportedOperationException("doSetValue should not be necessary since the library anymore!");
    }

    public UrlReference getUrlReference() {
        return this.url;
    }

    public static List<UrlReference> toUrlReferences(List<UrlNode> urlNodes) {
        return urlNodes.stream().map(UrlNode::getUrlReference).collect(Collectors.toList());
    }

    public static Map<String, UrlReference> toUrlReferenceMap(Map<String, UrlNode> urlNodeMap) {
        return urlNodeMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((UrlNode)e.getValue()).getUrlReference()));
    }
}

