/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class FileReference {
    private final String value;

    FileReference(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof FileReference && this.value.equals(((FileReference)other).value);
    }

    public String toString() {
        return "file '" + this.value + "'";
    }

    public static List<String> toValues(Collection<FileReference> references) {
        ArrayList<String> ret = new ArrayList<String>();
        for (FileReference r : references) {
            ret.add(r.value());
        }
        return ret;
    }

    public static Map<String, String> toValueMap(Map<String, FileReference> map) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (Map.Entry<String, FileReference> e : map.entrySet()) {
            ret.put(e.getKey(), e.getValue().value());
        }
        return ret;
    }

    public static FileReference mockFileReferenceForUnitTesting(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' does not exist.");
        }
        return new FileReference(file.getPath());
    }
}

